/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api;

import com.fusionflux.gravity_api.util.QuaternionUtil;
import com.fusionflux.gravity_api.util.RotationUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.apache.commons.lang3.Validate;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RotationAnimation {
    private boolean inAnimation = false;
    private Quaternionf startGravityRotation;
    private Quaternionf endGravityRotation;
    private long startTimeMs;
    private long endTimeMs;

    public void applyRotationAnimation(class_2350 newGravity, class_2350 prevGravity, long durationTimeMs, class_1297 entity, long timeMs, boolean rotateView) {
        if (durationTimeMs == 0L) {
            this.inAnimation = false;
            return;
        }
        Validate.notNull((Object)entity);
        class_243 newLookingDirection = this.getNewLookingDirection(newGravity, prevGravity, entity);
        Quaternionf oldViewRotation = QuaternionUtil.getViewRotation(entity.method_36455(), entity.method_36454());
        Quaternionf currentAnimatedGravityRotation = this.getCurrentGravityRotation(prevGravity, timeMs);
        Quaternionf currentAnimatedCameraRotation = new Quaternionf().set((Quaternionfc)oldViewRotation).mul((Quaternionfc)currentAnimatedGravityRotation);
        Quaternionf newEndGravityRotation = RotationUtil.getWorldRotationQuaternion(newGravity);
        class_241 newYawAndPitch = RotationUtil.vecToRot(RotationUtil.vecWorldToPlayer(newLookingDirection, newGravity));
        float newPitch = newYawAndPitch.field_1342;
        float newYaw = newYawAndPitch.field_1343;
        float deltaYaw = newYaw - entity.method_36454();
        float deltaPitch = newPitch - entity.method_36455();
        entity.method_36456(entity.method_36454() + deltaYaw);
        entity.method_36457(entity.method_36455() + deltaPitch);
        entity.field_5982 += deltaYaw;
        entity.field_6004 += deltaPitch;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.field_6283 += deltaYaw;
            livingEntity.field_6220 += deltaYaw;
            livingEntity.field_6241 += deltaYaw;
            livingEntity.field_6259 += deltaYaw;
        }
        Quaternionf newViewRotation = QuaternionUtil.getViewRotation(entity.method_36455(), entity.method_36454());
        Quaternionf animationStartGravityRotation = new Quaternionf().set((Quaternionfc)newViewRotation).conjugate().mul((Quaternionfc)currentAnimatedCameraRotation);
        this.inAnimation = true;
        this.startGravityRotation = animationStartGravityRotation;
        this.endGravityRotation = newEndGravityRotation;
        this.startTimeMs = timeMs;
        this.endTimeMs = timeMs + durationTimeMs;
    }

    private class_243 getNewLookingDirection(class_2350 newGravity, class_2350 prevGravity, class_1297 player) {
        class_243 oldLookingDirection = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(player.method_36454(), player.method_36455()), prevGravity);
        if (newGravity == prevGravity.method_10153()) {
            return oldLookingDirection.method_1021(-1.0);
        }
        Quaternionf deltaRotation = QuaternionUtil.getRotationBetween(class_243.method_24954((class_2382)prevGravity.method_10163()), class_243.method_24954((class_2382)newGravity.method_10163()));
        Vector3f lookingDirection = new Vector3f((float)oldLookingDirection.field_1352, (float)oldLookingDirection.field_1351, (float)oldLookingDirection.field_1350);
        lookingDirection.rotate((Quaternionfc)deltaRotation);
        class_243 newLookingDirection = new class_243(lookingDirection);
        return newLookingDirection;
    }

    public Quaternionf getCurrentGravityRotation(class_2350 currentGravity, long timeMs) {
        if (timeMs > this.endTimeMs) {
            this.inAnimation = false;
        }
        if (!this.inAnimation) {
            return RotationUtil.getWorldRotationQuaternion(currentGravity);
        }
        double delta = (double)(timeMs - this.startTimeMs) / (double)(this.endTimeMs - this.startTimeMs);
        class_310.method_1551().field_1769.method_3292();
        return RotationUtil.interpolate(this.startGravityRotation, this.endGravityRotation, RotationAnimation.mapProgress((float)delta));
    }

    private static float mapProgress(float delta) {
        return class_3532.method_15363((float)(delta * delta * (3.0f - 2.0f * delta)), (float)0.0f, (float)1.0f);
    }

    public boolean isInAnimation() {
        return this.inAnimation;
    }

    public void toNbt(class_2487 nbt) {
        nbt.method_10556("InAnimation", this.inAnimation);
        if (this.inAnimation) {
            nbt.method_10548("Q0X", this.startGravityRotation.x());
            nbt.method_10548("Q0Y", this.startGravityRotation.y());
            nbt.method_10548("Q0Z", this.startGravityRotation.z());
            nbt.method_10548("Q0W", this.startGravityRotation.w());
            nbt.method_10548("Q1X", this.endGravityRotation.x());
            nbt.method_10548("Q1Y", this.endGravityRotation.y());
            nbt.method_10548("Q1Z", this.endGravityRotation.z());
            nbt.method_10548("Q1W", this.endGravityRotation.w());
            nbt.method_10544("StartTime", this.startTimeMs);
            nbt.method_10544("EndTime", this.endTimeMs);
        }
    }

    public void fromNbt(class_2487 nbt) {
        this.inAnimation = nbt.method_10577("InAnimation");
        if (this.inAnimation) {
            this.startGravityRotation = new Quaternionf(nbt.method_10583("Q0X"), nbt.method_10583("Q0Y"), nbt.method_10583("Q0Z"), nbt.method_10583("Q0W"));
            this.endGravityRotation = new Quaternionf(nbt.method_10583("Q1X"), nbt.method_10583("Q1Y"), nbt.method_10583("Q1Z"), nbt.method_10583("Q1W"));
            this.startTimeMs = nbt.method_10537("StartTime");
            this.endTimeMs = nbt.method_10537("EndTime");
        }
    }
}

