/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.api;

import com.fusionflux.gravity_api.GravityChangerMod;
import com.fusionflux.gravity_api.RotationAnimation;
import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.EntityTags;
import com.fusionflux.gravity_api.util.Gravity;
import com.fusionflux.gravity_api.util.GravityChannel;
import com.fusionflux.gravity_api.util.GravityComponent;
import com.fusionflux.gravity_api.util.NetworkUtil;
import com.fusionflux.gravity_api.util.RotationUtil;
import com.fusionflux.gravity_api.util.packet.DefaultGravityPacket;
import com.fusionflux.gravity_api.util.packet.InvertGravityPacket;
import com.fusionflux.gravity_api.util.packet.OverwriteGravityPacket;
import com.fusionflux.gravity_api.util.packet.UpdateGravityPacket;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public abstract class GravityChangerAPI {
    public static final ComponentKey<GravityComponent> GRAVITY_COMPONENT = ComponentRegistry.getOrCreate((class_2960)new class_2960("gravityapi", "gravity_direction"), GravityComponent.class);

    private static <C extends Component, V> Optional<C> maybeGetSafe(ComponentKey<C> key, @Nullable V provider) {
        ComponentProvider p;
        ComponentContainer cc;
        if (provider instanceof ComponentProvider && (cc = (p = (ComponentProvider)provider).getComponentContainer()) != null) {
            return Optional.ofNullable(key.getInternal(cc));
        }
        return Optional.empty();
    }

    public static class_2350 getGravityDirection(class_1297 entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).map(GravityComponent::getGravityDirection).orElse(class_2350.field_11033);
        }
        return class_2350.field_11033;
    }

    public static ArrayList<Gravity> getGravityList(class_1297 entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).map(GravityComponent::getGravity).orElse(new ArrayList());
        }
        return new ArrayList<Gravity>();
    }

    public static class_2350 getPrevGravtityDirection(class_1297 entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).map(GravityComponent::getPrevGravityDirection).orElse(class_2350.field_11033);
        }
        return class_2350.field_11033;
    }

    public static class_2350 getDefaultGravityDirection(class_1297 entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).map(GravityComponent::getDefaultGravityDirection).orElse(class_2350.field_11033);
        }
        return class_2350.field_11033;
    }

    public static class_2350 getActualGravityDirection(class_1297 entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).map(GravityComponent::getActualGravityDirection).orElse(class_2350.field_11033);
        }
        return class_2350.field_11033;
    }

    public static boolean getIsInverted(class_1297 entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).map(GravityComponent::getInvertGravity).orElse(false);
        }
        return false;
    }

    public static Optional<RotationAnimation> getGravityAnimation(class_1297 entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).map(GravityComponent::getGravityAnimation);
        }
        return Optional.empty();
    }

    public static void addGravity(class_1297 entity, Gravity gravity) {
        if (GravityChangerAPI.onCorrectSide(entity, true) && EntityTags.canChangeGravity(entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.addGravity(gravity, false);
                GravityChannel.UPDATE_GRAVITY.sendToClient(entity, new UpdateGravityPacket(gravity, false), NetworkUtil.PacketMode.EVERYONE);
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void addGravityClient(class_746 entity, Gravity gravity, class_2960 verifier, class_2540 verifierInfo) {
        if (GravityChangerAPI.onCorrectSide((class_1297)entity, false) && EntityTags.canChangeGravity((class_1297)entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.addGravity(gravity, false);
                GravityChannel.UPDATE_GRAVITY.sendToServer(new UpdateGravityPacket(gravity, false), verifier, verifierInfo);
            });
        }
    }

    public static void updateGravity(class_1297 entity) {
        GravityChangerAPI.updateGravity(entity, new RotationParameters());
    }

    public static void updateGravity(class_1297 entity, RotationParameters rotationParameters) {
        if (EntityTags.canChangeGravity(entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> gc.updateGravity(rotationParameters, false));
        }
    }

    public static void setGravity(class_1297 entity, ArrayList<Gravity> gravity) {
        if (GravityChangerAPI.onCorrectSide(entity, true) && EntityTags.canChangeGravity(entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.setGravity(gravity, false);
                GravityChannel.OVERWRITE_GRAVITY.sendToClient(entity, new OverwriteGravityPacket(gravity, false), NetworkUtil.PacketMode.EVERYONE);
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void setGravityClient(class_746 entity, ArrayList<Gravity> gravity, class_2960 verifier, class_2540 verifierInfo) {
        if (GravityChangerAPI.onCorrectSide((class_1297)entity, false) && EntityTags.canChangeGravity((class_1297)entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.setGravity(gravity, false);
                GravityChannel.OVERWRITE_GRAVITY.sendToServer(new OverwriteGravityPacket(gravity, false), verifier, verifierInfo);
            });
        }
    }

    public static void setIsInverted(class_1297 entity, boolean isInverted) {
        GravityChangerAPI.setIsInverted(entity, isInverted, new RotationParameters());
    }

    public static void setIsInverted(class_1297 entity, boolean isInverted, RotationParameters rotationParameters) {
        if (GravityChangerAPI.onCorrectSide(entity, true) && EntityTags.canChangeGravity(entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.invertGravity(isInverted, rotationParameters, false);
                GravityChannel.INVERT_GRAVITY.sendToClient(entity, new InvertGravityPacket(isInverted, rotationParameters, false), NetworkUtil.PacketMode.EVERYONE);
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void setIsInvertedClient(class_746 entity, boolean isInverted, RotationParameters rotationParameters, class_2960 verifier, class_2540 verifierInfo) {
        if (GravityChangerAPI.onCorrectSide((class_1297)entity, false) && EntityTags.canChangeGravity((class_1297)entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.invertGravity(isInverted, rotationParameters, false);
                GravityChannel.INVERT_GRAVITY.sendToServer(new InvertGravityPacket(isInverted, rotationParameters, false), verifier, verifierInfo);
            });
        }
    }

    public static void clearGravity(class_1297 entity) {
        GravityChangerAPI.clearGravity(entity, new RotationParameters());
    }

    public static void clearGravity(class_1297 entity, RotationParameters rotationParameters) {
        if (GravityChangerAPI.onCorrectSide(entity, true) && EntityTags.canChangeGravity(entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.clearGravity(rotationParameters, false);
                GravityChannel.OVERWRITE_GRAVITY.sendToClient(entity, new OverwriteGravityPacket(new ArrayList<Gravity>(), false), NetworkUtil.PacketMode.EVERYONE);
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void clearGravityClient(class_746 entity, RotationParameters rotationParameters, class_2960 verifier, class_2540 verifierInfo) {
        if (GravityChangerAPI.onCorrectSide((class_1297)entity, false) && EntityTags.canChangeGravity((class_1297)entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.clearGravity(rotationParameters, false);
                GravityChannel.OVERWRITE_GRAVITY.sendToServer(new OverwriteGravityPacket(new ArrayList<Gravity>(), false), verifier, verifierInfo);
            });
        }
    }

    @Deprecated
    public static void setDefaultGravityDirection(class_1297 entity, class_2350 gravityDirection, int animationDurationMs) {
        GravityChangerAPI.setDefaultGravityDirection(entity, gravityDirection, new RotationParameters().rotationTime(animationDurationMs));
    }

    public static void setDefaultGravityDirection(class_1297 entity, class_2350 gravityDirection) {
        GravityChangerAPI.setDefaultGravityDirection(entity, gravityDirection, new RotationParameters());
    }

    public static void setDefaultGravityDirection(class_1297 entity, class_2350 gravityDirection, RotationParameters rotationParameters) {
        if (GravityChangerAPI.onCorrectSide(entity, true) && EntityTags.canChangeGravity(entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.setDefaultGravityDirection(gravityDirection, rotationParameters, false);
                GravityChannel.DEFAULT_GRAVITY.sendToClient(entity, new DefaultGravityPacket(gravityDirection, rotationParameters, false), NetworkUtil.PacketMode.EVERYONE);
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void setDefaultGravityDirectionClient(class_746 entity, class_2350 gravityDirection, RotationParameters rotationParameters, class_2960 verifier, class_2540 verifierInfo) {
        if (GravityChangerAPI.onCorrectSide((class_1297)entity, false) && EntityTags.canChangeGravity((class_1297)entity)) {
            GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).ifPresent(gc -> {
                gc.setDefaultGravityDirection(gravityDirection, rotationParameters, false);
                GravityChannel.DEFAULT_GRAVITY.sendToServer(new DefaultGravityPacket(gravityDirection, rotationParameters, false), verifier, verifierInfo);
            });
        }
    }

    @Nullable
    public static GravityComponent getGravityComponent(class_1297 entity) {
        return GravityChangerAPI.maybeGetSafe(GRAVITY_COMPONENT, entity).orElse(null);
    }

    public static class_243 getWorldVelocity(class_1297 playerEntity) {
        return RotationUtil.vecPlayerToWorld(playerEntity.method_18798(), GravityChangerAPI.getGravityDirection(playerEntity));
    }

    public static void setWorldVelocity(class_1297 entity, class_243 worldVelocity) {
        entity.method_18799(RotationUtil.vecWorldToPlayer(worldVelocity, GravityChangerAPI.getGravityDirection(entity)));
    }

    public static class_243 getEyeOffset(class_1297 entity) {
        return RotationUtil.vecPlayerToWorld(0.0, (double)entity.method_5751(), 0.0, GravityChangerAPI.getGravityDirection(entity));
    }

    private static boolean onCorrectSide(class_1297 entity, boolean shouldBeOnServer) {
        if (entity.field_6002.field_9236 && shouldBeOnServer) {
            GravityChangerMod.LOGGER.error("GravityChangerAPI function cannot be called from the server, use dedicated client server. ", (Throwable)new Exception());
            return false;
        }
        if (!entity.field_6002.field_9236 && !shouldBeOnServer) {
            GravityChangerMod.LOGGER.error("GravityChangerAPI function cannot be called from the client, use dedicated client client. ", (Throwable)new Exception());
            return false;
        }
        return true;
    }
}

