/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.command;

import com.fusionflux.gravity_api.api.GravityChangerAPI;
import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.Gravity;
import com.fusionflux.gravity_api.util.RotationUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5819;

public class GravityCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literalSet = class_2170.method_9247((String)"add");
        for (class_2350 direction : class_2350.values()) {
            literalSet.then(class_2170.method_9247((String)direction.method_10151()).then(class_2170.method_9244((String)"priority", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer()).executes(context -> GravityCommand.executeSet((class_2168)context.getSource(), direction, IntegerArgumentType.getInteger((CommandContext)context, (String)"priority"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), Collections.singleton(((class_2168)context.getSource()).method_44023())))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> GravityCommand.executeSet((class_2168)context.getSource(), direction, IntegerArgumentType.getInteger((CommandContext)context, (String)"priority"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), class_2186.method_9317((CommandContext)context, (String)"entities")))))));
        }
        LiteralArgumentBuilder literalSetDefault = class_2170.method_9247((String)"set");
        for (class_2350 direction : class_2350.values()) {
            literalSetDefault.then(((LiteralArgumentBuilder)class_2170.method_9247((String)direction.method_10151()).executes(context -> GravityCommand.executeSetDefault((class_2168)context.getSource(), direction, Collections.singleton(((class_2168)context.getSource()).method_44023())))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> GravityCommand.executeSetDefault((class_2168)context.getSource(), direction, class_2186.method_9317((CommandContext)context, (String)"entities")))));
        }
        LiteralArgumentBuilder literalRotate = class_2170.method_9247((String)"rotate");
        for (FacingDirection facingDirection : FacingDirection.values()) {
            literalRotate.then(((LiteralArgumentBuilder)class_2170.method_9247((String)facingDirection.getName()).executes(context -> GravityCommand.executeRotate((class_2168)context.getSource(), facingDirection, Collections.singleton(((class_2168)context.getSource()).method_44023())))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> GravityCommand.executeRotate((class_2168)context.getSource(), facingDirection, class_2186.method_9317((CommandContext)context, (String)"entities")))));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gravity").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> GravityCommand.executeGet((class_2168)context.getSource(), (class_1297)((class_2168)context.getSource()).method_44023()))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9309()).executes(context -> GravityCommand.executeGet((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entities")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cleargravity").executes(context -> GravityCommand.executeClearGravity((class_2168)context.getSource(), Collections.singleton(((class_2168)context.getSource()).method_44023())))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9309()).executes(context -> GravityCommand.executeClearGravity((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities")))))).then((ArgumentBuilder)literalSet)).then((ArgumentBuilder)literalSetDefault)).then((ArgumentBuilder)literalRotate)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"randomise").executes(context -> GravityCommand.executeRandomise((class_2168)context.getSource(), Collections.singleton(((class_2168)context.getSource()).method_44023())))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> GravityCommand.executeRandomise((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"))))));
    }

    private static void getSendFeedback(class_2168 source, class_1297 entity, class_2350 gravityDirection) {
        class_5250 text = class_2561.method_43471((String)("direction." + gravityDirection.method_10151()));
        if (source.method_9228() != null && source.method_9228() == entity) {
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.gravity.get.self", (Object[])new Object[]{text}), true);
        } else {
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.gravity.get.other", (Object[])new Object[]{entity.method_5476(), text}), true);
        }
    }

    private static int executeGet(class_2168 source, class_1297 entity) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        GravityCommand.getSendFeedback(source, entity, gravityDirection);
        return gravityDirection.method_10146();
    }

    private static int executeSet(class_2168 source, class_2350 gravityDirection, int priority, int durration, Collection<? extends class_1297> entities) {
        int i = 0;
        for (class_1297 class_12972 : entities) {
            GravityChangerAPI.addGravity(class_12972, new Gravity(gravityDirection, priority, durration, "command"));
            ++i;
        }
        return i;
    }

    private static int executeSetDefault(class_2168 source, class_2350 gravityDirection, Collection<? extends class_1297> entities) {
        int i = 0;
        for (class_1297 class_12972 : entities) {
            if (GravityChangerAPI.getDefaultGravityDirection(class_12972) == gravityDirection) continue;
            GravityChangerAPI.setDefaultGravityDirection(class_12972, gravityDirection, new RotationParameters());
            GravityCommand.getSendFeedback(source, class_12972, gravityDirection);
            ++i;
        }
        return i;
    }

    private static int executeRotate(class_2168 source, FacingDirection relativeDirection, Collection<? extends class_1297> entities) {
        int i = 0;
        for (class_1297 class_12972 : entities) {
            class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(class_12972);
            class_2350 combinedRelativeDirection = switch (relativeDirection) {
                default -> throw new IncompatibleClassChangeError();
                case FacingDirection.DOWN -> class_2350.field_11033;
                case FacingDirection.UP -> class_2350.field_11036;
                case FacingDirection.FORWARD, FacingDirection.BACKWARD, FacingDirection.LEFT, FacingDirection.RIGHT -> class_2350.method_10139((int)(relativeDirection.getHorizontalOffset() + class_2350.method_10150((double)class_12972.method_36454()).method_10161()));
            };
            class_2350 newGravityDirection = RotationUtil.dirPlayerToWorld(combinedRelativeDirection, gravityDirection);
            GravityChangerAPI.setDefaultGravityDirection(class_12972, newGravityDirection, new RotationParameters());
            GravityCommand.getSendFeedback(source, class_12972, newGravityDirection);
            ++i;
        }
        return i;
    }

    private static int executeRandomise(class_2168 source, Collection<? extends class_1297> entities) {
        int i = 0;
        for (class_1297 class_12972 : entities) {
            class_2350 gravityDirection = class_2350.method_10162((class_5819)source.method_9225().field_9229);
            if (GravityChangerAPI.getGravityDirection(class_12972) == gravityDirection) continue;
            GravityChangerAPI.setDefaultGravityDirection(class_12972, gravityDirection, new RotationParameters());
            GravityCommand.getSendFeedback(source, class_12972, gravityDirection);
            ++i;
        }
        return i;
    }

    private static int executeClearGravity(class_2168 source, Collection<? extends class_1297> entities) {
        int i = 0;
        for (class_1297 class_12972 : entities) {
            GravityChangerAPI.clearGravity(class_12972, new RotationParameters());
            ++i;
        }
        return i;
    }

    public static enum FacingDirection {
        DOWN(-1, "down"),
        UP(-1, "up"),
        FORWARD(0, "forward"),
        BACKWARD(2, "backward"),
        LEFT(3, "left"),
        RIGHT(1, "right");

        private final int horizontalOffset;
        private final String name;

        private FacingDirection(int horizontalOffset, String name) {
            this.horizontalOffset = horizontalOffset;
            this.name = name;
        }

        public int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public String getName() {
            return this.name;
        }
    }
}

