/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.mixin;

import com.fusionflux.gravity_api.api.GravityChangerAPI;
import com.fusionflux.gravity_api.util.RotationUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    @Shadow
    @Final
    private class_1656 field_7503;

    @Shadow
    public abstract class_4048 method_18377(class_4050 var1);

    @Shadow
    protected abstract boolean method_21825();

    @Shadow
    protected abstract boolean method_30263();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getRotationVector()Lnet/minecraft/util/math/Vec3d;", ordinal=0))
    private class_243 redirect_travel_getRotationVector_0(class_1657 playerEntity) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)playerEntity);
        if (gravityDirection == class_2350.field_11033) {
            return playerEntity.method_5720();
        }
        return RotationUtil.vecWorldToPlayer(playerEntity.method_5720(), gravityDirection);
    }

    @ModifyArgs(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;ofFloored(DDD)Lnet/minecraft/util/math/BlockPos;", ordinal=0))
    private void modify_move_multiply_0(Args args) {
        class_243 rotate = new class_243(0.0, 0.9, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((class_1297)this));
        args.set(0, (Object)((Double)args.get(0) - rotate.field_1352));
        args.set(1, (Object)((Double)args.get(1) - rotate.field_1351 + 0.9));
        args.set(2, (Object)((Double)args.get(2) - rotate.field_1350));
    }

    @Redirect(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, at=@At(value="NEW", target="net/minecraft/entity/ItemEntity", ordinal=0))
    private class_1542 redirect_dropItem_new_0(class_1937 world, double x, double y, double z, class_1799 stack) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return new class_1542(world, x, y, z, stack);
        }
        class_243 vec3d = this.method_33571().method_1020(RotationUtil.vecPlayerToWorld(0.0, (double)0.3f, 0.0, gravityDirection));
        return new class_1542(world, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, stack);
    }

    @Redirect(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;setVelocity(DDD)V"))
    private void redirect_dropItem_setVelocity(class_1542 itemEntity, double x, double y, double z) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            itemEntity.method_18800(x, y, z);
            return;
        }
        itemEntity.method_18799(RotationUtil.vecPlayerToWorld(x, y, z, gravityDirection));
    }

    @Inject(method={"adjustMovementForSneaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_adjustMovementForSneaking(class_243 movement, class_1313 type, CallbackInfoReturnable<class_243> cir) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_243 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        if (!this.field_7503.field_7479 && (type == class_1313.field_6308 || type == class_1313.field_6305) && this.method_21825() && this.method_30263()) {
            double d = playerMovement.field_1352;
            double e = playerMovement.field_1350;
            double var7 = 0.05;
            while (d != 0.0 && this.field_6002.method_8587((class_1297)this, this.method_5829().method_997(RotationUtil.vecPlayerToWorld(d, (double)(-this.method_49476()), 0.0, gravityDirection)))) {
                if (d < 0.05 && d >= -0.05) {
                    d = 0.0;
                    continue;
                }
                if (d > 0.0) {
                    d -= 0.05;
                    continue;
                }
                d += 0.05;
            }
            while (e != 0.0 && this.field_6002.method_8587((class_1297)this, this.method_5829().method_997(RotationUtil.vecPlayerToWorld(0.0, (double)(-this.method_49476()), e, gravityDirection)))) {
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            while (d != 0.0 && e != 0.0 && this.field_6002.method_8587((class_1297)this, this.method_5829().method_997(RotationUtil.vecPlayerToWorld(d, (double)(-this.method_49476()), e, gravityDirection)))) {
                d = d < 0.05 && d >= -0.05 ? 0.0 : (d > 0.0 ? (d -= 0.05) : (d += 0.05));
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(d, playerMovement.field_1351, e, gravityDirection));
        } else {
            cir.setReturnValue((Object)movement);
        }
    }

    @Redirect(method={"method_30263"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;offset(DDD)Lnet/minecraft/util/math/Box;", ordinal=0))
    private class_238 redirect_method_30263_offset_0(class_238 box, double x, double y, double z) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return box.method_989(x, y, z);
        }
        return box.method_997(RotationUtil.vecPlayerToWorld(x, y, z, gravityDirection));
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getYaw()F", ordinal=0))
    private float redirect_attack_getYaw_0(class_1657 attacker, class_1297 target) {
        class_2350 attackerGravityDirection;
        class_2350 targetGravityDirection = GravityChangerAPI.getGravityDirection(target);
        if (targetGravityDirection == (attackerGravityDirection = GravityChangerAPI.getGravityDirection((class_1297)attacker))) {
            return attacker.method_36454();
        }
        return RotationUtil.rotWorldToPlayer((class_241)RotationUtil.rotPlayerToWorld((float)attacker.method_36454(), (float)attacker.method_36455(), (class_2350)attackerGravityDirection), (class_2350)targetGravityDirection).field_1343;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getYaw()F", ordinal=1))
    private float redirect_attack_getYaw_1(class_1657 attacker, class_1297 target) {
        class_2350 attackerGravityDirection;
        class_2350 targetGravityDirection = GravityChangerAPI.getGravityDirection(target);
        if (targetGravityDirection == (attackerGravityDirection = GravityChangerAPI.getGravityDirection((class_1297)attacker))) {
            return attacker.method_36454();
        }
        return RotationUtil.rotWorldToPlayer((class_241)RotationUtil.rotPlayerToWorld((float)attacker.method_36454(), (float)attacker.method_36455(), (class_2350)attackerGravityDirection), (class_2350)targetGravityDirection).field_1343;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getYaw()F", ordinal=2))
    private float redirect_attack_getYaw_2(class_1657 attacker) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)attacker);
        if (gravityDirection == class_2350.field_11033) {
            return attacker.method_36454();
        }
        return RotationUtil.rotPlayerToWorld((float)attacker.method_36454(), (float)attacker.method_36455(), (class_2350)gravityDirection).field_1343;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getYaw()F", ordinal=3))
    private float redirect_attack_getYaw_3(class_1657 attacker) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)attacker);
        if (gravityDirection == class_2350.field_11033) {
            return attacker.method_36454();
        }
        return RotationUtil.rotPlayerToWorld((float)attacker.method_36454(), (float)attacker.method_36455(), (class_2350)gravityDirection).field_1343;
    }

    @ModifyArgs(method={"spawnParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;addParticle(Lnet/minecraft/particle/ParticleEffect;DDDDDD)V", ordinal=0))
    private void modify_addDeathParticless_addParticle_0(Args args) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_243 vec3d = this.method_19538().method_1020(RotationUtil.vecPlayerToWorld(this.method_19538().method_1023(((Double)args.get(1)).doubleValue(), ((Double)args.get(2)).doubleValue(), ((Double)args.get(3)).doubleValue()), gravityDirection));
        args.set(1, (Object)vec3d.field_1352);
        args.set(2, (Object)vec3d.field_1351);
        args.set(3, (Object)vec3d.field_1350);
    }

    @ModifyArgs(method={"tickMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;", ordinal=0))
    private void modify_tickMovement_expand_0(Args args) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_243 vec3d = RotationUtil.maskPlayerToWorld((Double)args.get(0), (Double)args.get(1), (Double)args.get(2), gravityDirection);
        args.set(0, (Object)vec3d.field_1352);
        args.set(1, (Object)vec3d.field_1351);
        args.set(2, (Object)vec3d.field_1350);
    }

    @ModifyArgs(method={"tickMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;", ordinal=1))
    private void modify_tickMovement_expand_1(Args args) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_243 vec3d = RotationUtil.maskPlayerToWorld((Double)args.get(0), (Double)args.get(1), (Double)args.get(2), gravityDirection);
        args.set(0, (Object)vec3d.field_1352);
        args.set(1, (Object)vec3d.field_1351);
        args.set(2, (Object)vec3d.field_1350);
    }
}

