/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.mixin.client;

import com.fusionflux.gravity_api.RotationAnimation;
import com.fusionflux.gravity_api.api.GravityChangerAPI;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class})
public abstract class CameraMixin {
    @Shadow
    private class_1297 field_18711;
    @Shadow
    @Final
    private Quaternionf field_21518;
    @Shadow
    private float field_18722;
    @Shadow
    private float field_18721;
    private float storedTickDelta = 0.0f;

    @Shadow
    protected abstract void method_19327(double var1, double var3, double var5);

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void inject_update(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        this.storedTickDelta = tickDelta;
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;setPos(DDD)V", ordinal=0))
    private void redirect_update_setPos_0(class_4184 camera, double x, double y, double z, class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(focusedEntity);
        Optional<RotationAnimation> animationOptional = GravityChangerAPI.getGravityAnimation(focusedEntity);
        if (animationOptional.isEmpty()) {
            this.method_19327(x, y, z);
            return;
        }
        RotationAnimation animation = animationOptional.get();
        if (gravityDirection == class_2350.field_11033 && !animation.isInAnimation()) {
            this.method_19327(x, y, z);
            return;
        }
        long timeMs = focusedEntity.field_6002.method_8510() * 50L + (long)(this.storedTickDelta * 50.0f);
        Quaternionf gravityRotation = new Quaternionf((Quaternionfc)animation.getCurrentGravityRotation(gravityDirection, timeMs));
        gravityRotation.conjugate();
        double entityX = class_3532.method_16436((double)tickDelta, (double)focusedEntity.field_6014, (double)focusedEntity.method_23317());
        double entityY = class_3532.method_16436((double)tickDelta, (double)focusedEntity.field_6036, (double)focusedEntity.method_23318());
        double entityZ = class_3532.method_16436((double)tickDelta, (double)focusedEntity.field_5969, (double)focusedEntity.method_23321());
        double currentCameraY = class_3532.method_16439((float)tickDelta, (float)this.field_18722, (float)this.field_18721);
        Vector3f eyeOffset = new Vector3f(0.0f, (float)currentCameraY, 0.0f);
        eyeOffset.rotate((Quaternionfc)gravityRotation);
        this.method_19327(entityX + (double)eyeOffset.x(), entityY + (double)eyeOffset.y(), entityZ + (double)eyeOffset.z());
    }

    @Inject(method={"setRotation"}, at={@At(value="INVOKE", target="Lorg/joml/Quaternionf;rotationYXZ(FFF)Lorg/joml/Quaternionf;", shift=At.Shift.AFTER)})
    private void inject_setRotation(CallbackInfo ci) {
        if (this.field_18711 != null) {
            class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(this.field_18711);
            Optional<RotationAnimation> animationOptional = GravityChangerAPI.getGravityAnimation(this.field_18711);
            if (animationOptional.isEmpty()) {
                return;
            }
            RotationAnimation animation = animationOptional.get();
            if (gravityDirection == class_2350.field_11033 && !animation.isInAnimation()) {
                return;
            }
            long timeMs = this.field_18711.field_6002.method_8510() * 50L + (long)(this.storedTickDelta * 50.0f);
            Quaternionf rotation = new Quaternionf((Quaternionfc)animation.getCurrentGravityRotation(gravityDirection, timeMs));
            rotation.conjugate();
            rotation.mul((Quaternionfc)this.field_21518);
            this.field_21518.set(rotation.x(), rotation.y(), rotation.z(), rotation.w());
        }
    }
}

