/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.util;

import com.fusionflux.gravity_api.GravityChangerMod;
import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.GravityComponent;
import com.fusionflux.gravity_api.util.GravityVerifierRegistry;
import com.fusionflux.gravity_api.util.NetworkUtil;
import com.fusionflux.gravity_api.util.packet.DefaultGravityPacket;
import com.fusionflux.gravity_api.util.packet.GravityPacket;
import com.fusionflux.gravity_api.util.packet.InvertGravityPacket;
import com.fusionflux.gravity_api.util.packet.OverwriteGravityPacket;
import com.fusionflux.gravity_api.util.packet.UpdateGravityPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public class GravityChannel<P extends GravityPacket> {
    public static GravityChannel<OverwriteGravityPacket> OVERWRITE_GRAVITY = new GravityChannel<OverwriteGravityPacket>(OverwriteGravityPacket::new, GravityChangerMod.id("overwrite_gravity_list"));
    public static GravityChannel<UpdateGravityPacket> UPDATE_GRAVITY = new GravityChannel<UpdateGravityPacket>(UpdateGravityPacket::new, GravityChangerMod.id("update_gravity_list"));
    public static GravityChannel<DefaultGravityPacket> DEFAULT_GRAVITY = new GravityChannel<DefaultGravityPacket>(DefaultGravityPacket::new, GravityChangerMod.id("default_gravity"));
    public static GravityChannel<InvertGravityPacket> INVERT_GRAVITY = new GravityChannel<InvertGravityPacket>(InvertGravityPacket::new, GravityChangerMod.id("inverted"));
    private final Factory<P> packetFactory;
    private final class_2960 channel;
    private final GravityVerifierRegistry<P> gravityVerifierRegistry;

    GravityChannel(Factory<P> _packetFactory, class_2960 _channel) {
        this.packetFactory = _packetFactory;
        this.channel = _channel;
        this.gravityVerifierRegistry = new GravityVerifierRegistry();
    }

    public void sendToClient(class_1297 entity, P packet, NetworkUtil.PacketMode mode) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entity.method_5628());
        ((GravityPacket)packet).write(buf);
        NetworkUtil.sendToTracking(entity, this.channel, buf, mode);
    }

    public void receiveFromServer(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        Object packet = this.packetFactory.read(buf);
        client.execute(() -> NetworkUtil.getGravityComponent(client, entityId).ifPresent(packet::run));
    }

    public void sendToServer(P packet, class_2960 verifier, class_2540 verifierInfoBuf) {
        class_2540 buf = PacketByteBufs.create();
        ((GravityPacket)packet).write(buf);
        buf.method_10812(verifier);
        buf.method_10813(verifierInfoBuf.array());
        ClientPlayNetworking.send((class_2960)this.channel, (class_2540)buf);
    }

    public void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        P packet = this.packetFactory.read(buf);
        class_2960 verifier = buf.method_10810();
        class_2540 verifierInfoBuf = PacketByteBufs.create();
        verifierInfoBuf.writeBytes(buf.method_10795());
        server.execute(() -> NetworkUtil.getGravityComponent((class_1297)player).ifPresent(gc -> {
            GravityVerifierRegistry.VerifierFunction<P> v = this.gravityVerifierRegistry.get(verifier);
            if (v != null && v.check(player, verifierInfoBuf, packet)) {
                packet.run((GravityComponent)gc);
                this.sendToClient((class_1297)player, packet, NetworkUtil.PacketMode.EVERYONE_BUT_SELF);
            } else {
                GravityChangerMod.LOGGER.info("VerifierFunction returned FALSE");
                GravityChannel.sendFullStatePacket((class_1297)player, NetworkUtil.PacketMode.ONLY_SELF, packet.getRotationParameters(), false);
            }
        }));
    }

    public static void sendFullStatePacket(class_1297 entity, NetworkUtil.PacketMode mode, RotationParameters rp, boolean initialGravity) {
        NetworkUtil.getGravityComponent(entity).ifPresent(gc -> {
            OVERWRITE_GRAVITY.sendToClient(entity, new OverwriteGravityPacket(gc.getGravity(), initialGravity), mode);
            DEFAULT_GRAVITY.sendToClient(entity, new DefaultGravityPacket(gc.getDefaultGravityDirection(), rp, initialGravity), mode);
            INVERT_GRAVITY.sendToClient(entity, new InvertGravityPacket(gc.getInvertGravity(), rp, initialGravity), mode);
        });
    }

    public GravityVerifierRegistry<P> getVerifierRegistry() {
        return this.gravityVerifierRegistry;
    }

    public void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.channel, this::receiveFromServer);
    }

    public void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.channel, this::receiveFromClient);
    }

    public static void initClient() {
        DEFAULT_GRAVITY.registerClientReceiver();
        UPDATE_GRAVITY.registerClientReceiver();
        OVERWRITE_GRAVITY.registerClientReceiver();
        INVERT_GRAVITY.registerClientReceiver();
    }

    public static void initServer() {
        DEFAULT_GRAVITY.registerServerReceiver();
        UPDATE_GRAVITY.registerServerReceiver();
        OVERWRITE_GRAVITY.registerServerReceiver();
        INVERT_GRAVITY.registerServerReceiver();
    }

    @FunctionalInterface
    static interface Factory<T extends GravityPacket> {
        public T read(class_2540 var1);
    }
}

