/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.util;

import com.fusionflux.gravity_api.RotationAnimation;
import com.fusionflux.gravity_api.api.GravityChangerAPI;
import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.EntityTags;
import com.fusionflux.gravity_api.util.Gravity;
import com.fusionflux.gravity_api.util.GravityChannel;
import com.fusionflux.gravity_api.util.GravityComponent;
import com.fusionflux.gravity_api.util.NetworkUtil;
import com.fusionflux.gravity_api.util.RotationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1536;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_3222;
import net.minecraft.class_4048;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GravityDirectionComponent
implements GravityComponent {
    class_2350 gravityDirection = class_2350.field_11033;
    class_2350 defaultGravityDirection = class_2350.field_11033;
    class_2350 prevGravityDirection = class_2350.field_11033;
    boolean isInverted = false;
    RotationAnimation animation = new RotationAnimation();
    boolean needsInitialSync = false;
    ArrayList<Gravity> gravityList = new ArrayList();
    private final class_1297 entity;

    public GravityDirectionComponent(class_1297 entity) {
        this.entity = entity;
    }

    @Override
    public void onGravityChanged(class_2350 oldGravity, class_2350 newGravity, RotationParameters rotationParameters, boolean initialGravity) {
        this.entity.field_6017 = 0.0f;
        this.entity.method_33574(this.entity.method_19538());
        if (!initialGravity) {
            if (!(this.entity instanceof class_3222)) {
                class_243 relativeRotationCentre = this.getCentreOfRotation(oldGravity, newGravity, rotationParameters);
                class_243 translation = RotationUtil.vecPlayerToWorld(relativeRotationCentre, oldGravity).method_1020(RotationUtil.vecPlayerToWorld(relativeRotationCentre, newGravity));
                class_2350 relativeDirection = RotationUtil.dirWorldToPlayer(newGravity, oldGravity);
                class_243 smidge = new class_243(relativeDirection == class_2350.field_11034 ? -1.0E-6 : 0.0, relativeDirection == class_2350.field_11036 ? -1.0E-6 : 0.0, relativeDirection == class_2350.field_11035 ? -1.0E-6 : 0.0);
                smidge = RotationUtil.vecPlayerToWorld(smidge, oldGravity);
                this.entity.method_33574(this.entity.method_19538().method_1019(translation).method_1019(smidge));
                if (this.shouldChangeVelocity() && !rotationParameters.alternateCenter()) {
                    this.adjustEntityPosition(oldGravity, newGravity);
                }
            }
            if (this.shouldChangeVelocity()) {
                class_243 realWorldVelocity = this.getRealWorldVelocity(this.entity, this.prevGravityDirection);
                if (rotationParameters.rotateVelocity()) {
                    Vector3f worldSpaceVec = realWorldVelocity.method_46409();
                    worldSpaceVec.rotate((Quaternionfc)RotationUtil.getRotationBetween(this.prevGravityDirection, this.gravityDirection));
                    this.entity.method_18799(RotationUtil.vecWorldToPlayer(new class_243(worldSpaceVec), this.gravityDirection));
                } else {
                    this.entity.method_18799(RotationUtil.vecWorldToPlayer(realWorldVelocity, this.gravityDirection));
                }
            }
        }
    }

    private class_243 getRealWorldVelocity(class_1297 entity, class_2350 prevGravityDirection) {
        if (entity.method_5787()) {
            return new class_243(entity.method_23317() - entity.field_6014, entity.method_23318() - entity.field_6036, entity.method_23321() - entity.field_5969);
        }
        return RotationUtil.vecPlayerToWorld(entity.method_18798(), prevGravityDirection);
    }

    private boolean shouldChangeVelocity() {
        if (this.entity instanceof class_1536) {
            return true;
        }
        if (this.entity instanceof class_1671) {
            return true;
        }
        return !(this.entity instanceof class_1676);
    }

    @NotNull
    private class_243 getCentreOfRotation(class_2350 oldGravity, class_2350 newGravity, RotationParameters rotationParameters) {
        class_243 relativeRotationCentre = class_243.field_1353;
        if (this.entity instanceof class_1511) {
            relativeRotationCentre = new class_243(0.0, -0.5, 0.0);
        } else if (rotationParameters.alternateCenter()) {
            class_4048 dimensions = this.entity.method_18377(this.entity.method_18376());
            relativeRotationCentre = newGravity.method_10153() == oldGravity ? new class_243(0.0, (double)(dimensions.field_18068 / 2.0f), 0.0) : new class_243(0.0, (double)(dimensions.field_18067 / 2.0f), 0.0);
        }
        return relativeRotationCentre;
    }

    private void adjustEntityPosition(class_2350 oldGravity, class_2350 newGravity) {
        if (this.entity instanceof class_1295 || this.entity instanceof class_1665 || this.entity instanceof class_1511) {
            return;
        }
        class_238 entityBoundingBox = this.entity.method_5829();
        class_2350 movingDirection = oldGravity.method_10153();
        Iterable collisions = this.entity.field_6002.method_8600(this.entity, entityBoundingBox);
        class_238 totalCollisionBox = null;
        for (class_265 collision : collisions) {
            if (collision.method_1110()) continue;
            class_238 boundingBox = collision.method_1107();
            if (totalCollisionBox == null) {
                totalCollisionBox = boundingBox;
                continue;
            }
            totalCollisionBox = totalCollisionBox.method_991(boundingBox);
        }
        if (totalCollisionBox != null) {
            this.entity.method_33574(this.entity.method_19538().method_1019(GravityDirectionComponent.getPositionAdjustmentOffset(entityBoundingBox, totalCollisionBox, movingDirection)));
        }
    }

    private static class_243 getPositionAdjustmentOffset(class_238 entityBoundingBox, class_238 nearbyCollisionUnion, class_2350 movingDirection) {
        class_2350.class_2351 axis = movingDirection.method_10166();
        double offset = 0.0;
        if (movingDirection.method_10171() == class_2350.class_2352.field_11056) {
            double pushed;
            double pushing = nearbyCollisionUnion.method_990(axis);
            if (pushing > (pushed = entityBoundingBox.method_1001(axis))) {
                offset = pushing - pushed;
            }
        } else {
            double pushed;
            double pushing = nearbyCollisionUnion.method_1001(axis);
            if (pushing < (pushed = entityBoundingBox.method_990(axis))) {
                offset = pushed - pushing;
            }
        }
        return new class_243(movingDirection.method_23955()).method_1021(offset);
    }

    @Override
    public class_2350 getGravityDirection() {
        if (this.canChangeGravity()) {
            return this.gravityDirection;
        }
        return class_2350.field_11033;
    }

    private boolean canChangeGravity() {
        return EntityTags.canChangeGravity(this.entity);
    }

    @Override
    public class_2350 getPrevGravityDirection() {
        if (this.canChangeGravity()) {
            return this.prevGravityDirection;
        }
        return class_2350.field_11033;
    }

    @Override
    public class_2350 getDefaultGravityDirection() {
        if (this.canChangeGravity()) {
            return this.defaultGravityDirection;
        }
        return class_2350.field_11033;
    }

    @Override
    public void updateGravity(RotationParameters rotationParameters, boolean initialGravity) {
        class_2350 newGravity;
        class_2350 oldGravity;
        if (this.canChangeGravity() && (oldGravity = this.gravityDirection) != (newGravity = this.getActualGravityDirection())) {
            long timeMs = this.entity.field_6002.method_8510() * 50L;
            if (this.entity.field_6002.field_9236) {
                this.animation.applyRotationAnimation(newGravity, oldGravity, initialGravity ? 0L : (long)rotationParameters.rotationTime(), this.entity, timeMs, rotationParameters.rotateView());
            }
            this.prevGravityDirection = oldGravity;
            this.gravityDirection = newGravity;
            this.onGravityChanged(oldGravity, newGravity, rotationParameters, initialGravity);
        }
    }

    @Override
    public class_2350 getActualGravityDirection() {
        class_2350 newGravity = this.getDefaultGravityDirection();
        Gravity highestPriority = this.getHighestPriority();
        if (highestPriority != null) {
            newGravity = highestPriority.direction();
        }
        if (this.isInverted) {
            newGravity = newGravity.method_10153();
        }
        return newGravity;
    }

    @Nullable
    private Gravity getHighestPriority() {
        if (!this.gravityList.isEmpty()) {
            return Collections.max(this.gravityList, Comparator.comparingInt(Gravity::priority));
        }
        return null;
    }

    @Override
    public void setDefaultGravityDirection(class_2350 gravityDirection, RotationParameters rotationParameters, boolean initialGravity) {
        if (this.canChangeGravity()) {
            this.defaultGravityDirection = gravityDirection;
            this.updateGravity(rotationParameters, initialGravity);
        }
    }

    @Override
    public void addGravity(Gravity gravity, boolean initialGravity) {
        if (this.canChangeGravity()) {
            this.gravityList.removeIf(g -> Objects.equals(g.source(), gravity.source()));
            if (gravity.direction() != null) {
                this.gravityList.add(gravity);
            }
            this.updateGravity(gravity.rotationParameters(), initialGravity);
        }
    }

    @Override
    public ArrayList<Gravity> getGravity() {
        return this.gravityList;
    }

    @Override
    public void setGravity(ArrayList<Gravity> _gravityList, boolean initialGravity) {
        Gravity highestBefore = this.getHighestPriority();
        this.gravityList = _gravityList;
        Gravity highestAfter = this.getHighestPriority();
        if (highestBefore != highestAfter) {
            if (highestBefore == null) {
                this.updateGravity(highestAfter.rotationParameters(), initialGravity);
            } else if (highestAfter == null) {
                this.updateGravity(highestBefore.rotationParameters(), initialGravity);
            } else if (highestBefore.priority() > highestAfter.priority()) {
                this.updateGravity(highestBefore.rotationParameters(), initialGravity);
            } else {
                this.updateGravity(highestAfter.rotationParameters(), initialGravity);
            }
        }
    }

    @Override
    public void invertGravity(boolean _isInverted, RotationParameters rotationParameters, boolean initialGravity) {
        this.isInverted = _isInverted;
        this.updateGravity(rotationParameters, initialGravity);
    }

    @Override
    public boolean getInvertGravity() {
        return this.isInverted;
    }

    @Override
    public void clearGravity(RotationParameters rotationParameters, boolean initialGravity) {
        this.gravityList.clear();
        this.updateGravity(rotationParameters, initialGravity);
    }

    @Override
    public RotationAnimation getGravityAnimation() {
        return this.animation;
    }

    public void readFromNbt(class_2487 nbt) {
        class_2350 oldDefaultGravity = this.defaultGravityDirection;
        ArrayList<Gravity> oldList = this.gravityList;
        boolean oldIsInverted = this.isInverted;
        if (nbt.method_10573("ListSize", 3)) {
            int listSize = nbt.method_10550("ListSize");
            ArrayList<Gravity> newGravityList = new ArrayList<Gravity>();
            if (listSize != 0) {
                for (int index = 0; index < listSize; ++index) {
                    Gravity newGravity = new Gravity(class_2350.method_10143((int)nbt.method_10550("GravityDirection " + index)), nbt.method_10550("GravityPriority " + index), nbt.method_10550("GravityDuration " + index), nbt.method_10558("GravitySource " + index));
                    newGravityList.add(newGravity);
                }
            }
            this.gravityList = newGravityList;
        }
        this.prevGravityDirection = class_2350.method_10143((int)nbt.method_10550("PrevGravityDirection"));
        this.defaultGravityDirection = class_2350.method_10143((int)nbt.method_10550("DefaultGravityDirection"));
        this.isInverted = nbt.method_10577("IsGravityInverted");
        RotationParameters rp = new RotationParameters(false, false, false, 0);
        this.updateGravity(rp, true);
        if (oldDefaultGravity != this.defaultGravityDirection) {
            this.needsInitialSync = true;
        }
        if (oldList.isEmpty() != this.gravityList.isEmpty()) {
            this.needsInitialSync = true;
        }
        if (oldIsInverted != this.isInverted) {
            this.needsInitialSync = true;
        }
    }

    public void writeToNbt(@NotNull class_2487 nbt) {
        int index = 0;
        for (Gravity temp : this.getGravity()) {
            if (temp.direction() == null || temp.source() == null) continue;
            nbt.method_10569("GravityDirection " + index, temp.direction().method_10146());
            nbt.method_10569("GravityPriority " + index, temp.priority());
            nbt.method_10569("GravityDuration " + index, temp.duration());
            nbt.method_10582("GravitySource " + index, temp.source());
            ++index;
        }
        nbt.method_10569("ListSize", index);
        nbt.method_10569("PrevGravityDirection", this.getPrevGravityDirection().method_10146());
        nbt.method_10569("DefaultGravityDirection", this.getDefaultGravityDirection().method_10146());
        nbt.method_10556("IsGravityInverted", this.getInvertGravity());
    }

    public void tick() {
        class_1297 vehicle = this.entity.method_5854();
        if (vehicle != null) {
            this.addGravity(new Gravity(GravityChangerAPI.getGravityDirection(vehicle), 99999999, 2, "vehicle"), true);
        }
        ArrayList<Gravity> gravityList = this.getGravity();
        Gravity highestBefore = this.getHighestPriority();
        if (gravityList.removeIf(g -> g.duration() == 0) && highestBefore != null) {
            this.updateGravity(highestBefore.rotationParameters(), false);
        }
        for (Gravity temp : gravityList) {
            if (temp.duration() <= 0) continue;
            temp.decrementDuration();
        }
        if (!this.entity.field_6002.field_9236 && this.needsInitialSync) {
            this.needsInitialSync = false;
            RotationParameters rotationParameters = new RotationParameters(false, false, false, 0);
            GravityChannel.sendFullStatePacket(this.entity, NetworkUtil.PacketMode.EVERYONE, rotationParameters, true);
        }
    }
}

