/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.util;

import com.fusionflux.gravity_api.api.GravityChangerAPI;
import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.Gravity;
import com.fusionflux.gravity_api.util.GravityComponent;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class NetworkUtil {
    public static Optional<GravityComponent> getGravityComponent(class_310 client, int entityId) {
        if (client.field_1687 == null) {
            return Optional.empty();
        }
        class_1297 entity = client.field_1687.method_8469(entityId);
        if (entity == null) {
            return Optional.empty();
        }
        GravityComponent gc = GravityChangerAPI.getGravityComponent(entity);
        if (gc == null) {
            return Optional.empty();
        }
        return Optional.of(gc);
    }

    public static Optional<GravityComponent> getGravityComponent(class_1297 entity) {
        GravityComponent gc = GravityChangerAPI.getGravityComponent(entity);
        if (gc == null) {
            return Optional.empty();
        }
        return Optional.of(gc);
    }

    public static void sendToTracking(class_1297 entity, class_2960 channel, class_2540 buf, PacketMode mode) {
        if (mode != PacketMode.EVERYONE_BUT_SELF && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ServerPlayNetworking.send((class_3222)player, (class_2960)channel, (class_2540)buf);
        }
        if (mode != PacketMode.ONLY_SELF) {
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                if (player == entity) continue;
                ServerPlayNetworking.send((class_3222)player, (class_2960)channel, (class_2540)buf);
            }
        }
    }

    public static void writeDirection(class_2540 buf, class_2350 direction) {
        buf.writeByte(direction == null ? -1 : direction.method_10146());
    }

    public static void writeRotationParameters(class_2540 buf, RotationParameters rotationParameters) {
        buf.writeBoolean(rotationParameters.rotateVelocity());
        buf.writeBoolean(rotationParameters.rotateView());
        buf.writeBoolean(rotationParameters.alternateCenter());
        buf.writeInt(rotationParameters.rotationTime());
    }

    public static void writeGravity(class_2540 buf, Gravity gravity) {
        NetworkUtil.writeDirection(buf, gravity.direction());
        buf.writeInt(gravity.priority());
        buf.writeInt(gravity.duration());
        buf.method_10814(gravity.source());
        NetworkUtil.writeRotationParameters(buf, gravity.rotationParameters());
    }

    public static RotationParameters readRotationParameters(class_2540 buf) {
        return new RotationParameters(buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readInt());
    }

    public static class_2350 readDirection(class_2540 buf) {
        byte rawDirection = buf.readByte();
        return 0 <= rawDirection && rawDirection < class_2350.values().length ? class_2350.method_10143((int)rawDirection) : null;
    }

    public static Gravity readGravity(class_2540 buf) {
        return new Gravity(NetworkUtil.readDirection(buf), buf.readInt(), buf.readInt(), buf.method_19772(), NetworkUtil.readRotationParameters(buf));
    }

    public static enum PacketMode {
        EVERYONE,
        EVERYONE_BUT_SELF,
        ONLY_SELF;

    }
}

