/*
 * Decompiled with CFR 0.152.
 */
package com.fusionflux.gravity_api.util.packet;

import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.Gravity;
import com.fusionflux.gravity_api.util.GravityComponent;
import com.fusionflux.gravity_api.util.NetworkUtil;
import com.fusionflux.gravity_api.util.packet.GravityPacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_2540;

public class OverwriteGravityPacket
extends GravityPacket {
    public final ArrayList<Gravity> gravityList;
    public final boolean initialGravity;

    public OverwriteGravityPacket(ArrayList<Gravity> _gravityList, boolean _initialGravity) {
        this.gravityList = _gravityList;
        this.initialGravity = _initialGravity;
    }

    public OverwriteGravityPacket(class_2540 buf) {
        int listSize = buf.readInt();
        this.gravityList = new ArrayList();
        for (int i = 0; i < listSize; ++i) {
            this.gravityList.add(NetworkUtil.readGravity(buf));
        }
        this.initialGravity = buf.readBoolean();
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.gravityList.size());
        for (Gravity gravity : this.gravityList) {
            NetworkUtil.writeGravity(buf, gravity);
        }
        buf.writeBoolean(this.initialGravity);
    }

    @Override
    public void run(GravityComponent gc) {
        gc.setGravity(this.gravityList, this.initialGravity);
    }

    @Override
    public RotationParameters getRotationParameters() {
        Optional<Gravity> max = this.gravityList.stream().max(Comparator.comparingInt(Gravity::priority));
        if (max.isEmpty()) {
            return new RotationParameters();
        }
        return max.get().rotationParameters();
    }
}

