/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatium;

import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import ru.blatfan.blatium.init.BlatiumArmorMaterial;
import ru.blatfan.blatium.item.BlatiumAxe;
import ru.blatfan.blatium.item.BlatiumHoe;
import ru.blatfan.blatium.item.BlatiumPickaxe;
import ru.blatfan.blatium.item.BlatiumShovel;
import ru.blatfan.blatium.item.BlatiumSword;
import ru.blatfan.blatium.item.NliumAxe;
import ru.blatfan.blatium.item.NliumHoe;
import ru.blatfan.blatium.item.NliumPickaxe;
import ru.blatfan.blatium.item.NliumShovel;
import ru.blatfan.blatium.item.NliumSword;

@Mod.EventBusSubscriber(modid="blatium", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    static ForgeConfigSpec SPEC;
    public static MaterialSetConfig BLATIUM_CONFIG;
    public static MaterialSetConfig NLIUM_CONFIG;

    private static MaterialSetConfig defineConfig(ForgeConfigSpec.Builder builder, String name, List<Integer> defenseValues, int toughness, double knockbackResistance, int swordDamage, float swordSpeed, int pickaxeDamage, float pickaxeSpeed, float pickaxeDestroyTime, int axeDamage, float axeSpeed, int shovelDamage, float shovelSpeed, int hoeDamage, float hoeSpeed) {
        builder.push(name);
        MaterialSetConfig config = new MaterialSetConfig((ForgeConfigSpec.ConfigValue<List<? extends Integer>>)builder.defineList("armor.values", () -> defenseValues, x -> true), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.define("armor.toughness", (Object)toughness), (ForgeConfigSpec.ConfigValue<? extends Double>)builder.define("armor.knockbackResistance", (Object)knockbackResistance), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.define("sword.damage", (Object)swordDamage), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.define("pickaxe.damage", (Object)pickaxeDamage), (ForgeConfigSpec.ConfigValue<? extends Float>)builder.define("pickaxe.destroyTime", (Object)Float.valueOf(pickaxeDestroyTime)), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.define("axe.damage", (Object)axeDamage), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.define("hoe.damage", (Object)hoeDamage), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.define("shovel.damage", (Object)shovelDamage), (ForgeConfigSpec.ConfigValue<? extends Float>)builder.define("sword.speed", (Object)Float.valueOf(swordSpeed)), (ForgeConfigSpec.ConfigValue<? extends Float>)builder.define("pickaxe.speed", (Object)Float.valueOf(pickaxeSpeed)), (ForgeConfigSpec.ConfigValue<? extends Float>)builder.define("axe.speed", (Object)Float.valueOf(axeSpeed)), (ForgeConfigSpec.ConfigValue<? extends Float>)builder.define("shovel.speed", (Object)Float.valueOf(shovelSpeed)), (ForgeConfigSpec.ConfigValue<? extends Float>)builder.define("hoe.speed", (Object)Float.valueOf(hoeSpeed)));
        builder.pop();
        return config;
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (BlatiumArmorMaterial value : BlatiumArmorMaterial.values()) {
            value.reload();
        }
        BlatiumSword.reload();
        BlatiumPickaxe.reload();
        BlatiumAxe.reload();
        BlatiumShovel.reload();
        BlatiumHoe.reload();
        NliumSword.reload();
        NliumPickaxe.reload();
        NliumAxe.reload();
        NliumShovel.reload();
        NliumHoe.reload();
    }

    static {
        BUILDER.push("Materials Config");
        BUILDER.comment("Changing armor and tools values requires game restart");
        BLATIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "blatium", List.of(Integer.valueOf(400), Integer.valueOf(550), Integer.valueOf(500), Integer.valueOf(400)), 25, 25.0, 750, 1.4f, 25, 1.2f, 10.0f, 800, 1.0f, 10, 1.0f, 10, 4.0f);
        NLIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "nlium", List.of(Integer.valueOf(800), Integer.valueOf(1100), Integer.valueOf(1000), Integer.valueOf(800)), 50, 50.0, 1500, 1.4f, 50, 1.2f, 20.0f, 1600, 1.0f, 20, 1.0f, 20, 4.0f);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public record MaterialSetConfig(ForgeConfigSpec.ConfigValue<List<? extends Integer>> defenseValues, ForgeConfigSpec.ConfigValue<? extends Integer> toughness, ForgeConfigSpec.ConfigValue<? extends Double> knockbackResistance, ForgeConfigSpec.ConfigValue<? extends Integer> swordDamage, ForgeConfigSpec.ConfigValue<? extends Integer> pickaxeDamage, ForgeConfigSpec.ConfigValue<? extends Float> pickaxeDestroyTime, ForgeConfigSpec.ConfigValue<? extends Integer> axeDamage, ForgeConfigSpec.ConfigValue<? extends Integer> shovelDamage, ForgeConfigSpec.ConfigValue<? extends Integer> hoeDamage, ForgeConfigSpec.ConfigValue<? extends Float> swordSpeed, ForgeConfigSpec.ConfigValue<? extends Float> pickaxeSpeed, ForgeConfigSpec.ConfigValue<? extends Float> axeSpeed, ForgeConfigSpec.ConfigValue<? extends Float> shovelSpeed, ForgeConfigSpec.ConfigValue<? extends Float> hoeSpeed) {
        public double getDefenseFor(EquipmentSlot slot) {
            if (((List)this.defenseValues.get()).size() != 4) {
                return ((Integer)((List)this.defenseValues.getDefault()).get(slot.m_20749_())).intValue();
            }
            return ((Integer)((List)this.defenseValues.get()).get(slot.m_20749_())).intValue();
        }
    }
}

