/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatium.compact.mekanism;

import java.util.function.Supplier;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.ResourceType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public enum BlatiumResource implements IResource
{
    BLATIUM("blatium", 13718243, (TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ores/blatium"))),
    NLIUM("nlium", 2547336, (TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ores/nlium")));

    private final String name;
    private final int tint;
    private final Supplier<TagKey<Item>> oreTag;
    private final boolean isVanilla;
    private final BlockResourceInfo resourceBlockInfo;
    private final BlockResourceInfo rawResourceBlockInfo;

    private BlatiumResource(String name, int color, TagKey<Item> oreTag) {
        this(name, color, () -> oreTag, true, null, null);
    }

    private BlatiumResource(String name, int tint, Supplier<TagKey<Item>> oreTag, boolean isVanilla, BlockResourceInfo resourceBlockInfo, BlockResourceInfo rawResourceBlockInfo) {
        this.name = name;
        this.tint = tint;
        this.oreTag = oreTag;
        this.isVanilla = isVanilla;
        this.resourceBlockInfo = resourceBlockInfo;
        this.rawResourceBlockInfo = rawResourceBlockInfo;
    }

    public String getRegistrySuffix() {
        return this.name;
    }

    public int getTint() {
        return this.tint;
    }

    public TagKey<Item> getOreTag() {
        return this.oreTag.get();
    }

    public boolean has(ResourceType type) {
        return type != ResourceType.ENRICHED && (!this.isVanilla || !type.isVanilla());
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    @Nullable
    public BlockResourceInfo getResourceBlockInfo() {
        return this.resourceBlockInfo;
    }

    @Nullable
    public BlockResourceInfo getRawResourceBlockInfo() {
        return this.rawResourceBlockInfo;
    }
}

