/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatium.init;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import ru.blatfan.blatium.ServerConfig;

public enum BlatiumArmorMaterial implements ArmorMaterial
{
    BLATIUM("blatium", ServerConfig.BLATIUM_CONFIG, 42, 85, SoundEvents.f_11679_, () -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/blatium")))),
    NLIUM("nlium", ServerConfig.NLIUM_CONFIG, 82, 125, SoundEvents.f_11679_, () -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/nlium"))));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final LazyLoadedValue<Ingredient> repairIngredient;
    private final ServerConfig.MaterialSetConfig config;
    private EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> slotToAttributeMap;
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT;

    private BlatiumArmorMaterial(String pName, ServerConfig.MaterialSetConfig config, int pDurabilityMultiplier, int pEnchantmentValue, SoundEvent pSound, Supplier<Ingredient> pRepairIngredient) {
        this.name = pName;
        this.durabilityMultiplier = pDurabilityMultiplier;
        this.enchantmentValue = pEnchantmentValue;
        this.sound = pSound;
        this.repairIngredient = new LazyLoadedValue(pRepairIngredient);
        this.config = config;
        this.slotToAttributeMap = null;
    }

    public EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> getSlotToAttributeMap() {
        if (this.slotToAttributeMap == null) {
            this.slotToAttributeMap = this.makeSlotToAttributeMap();
        }
        return this.slotToAttributeMap;
    }

    private EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> makeSlotToAttributeMap() {
        return (EnumMap)Util.m_137469_(new EnumMap(EquipmentSlot.class), map -> {
            map.put(EquipmentSlot.FEET, this.makeAttributeMap(EquipmentSlot.FEET));
            map.put(EquipmentSlot.LEGS, this.makeAttributeMap(EquipmentSlot.LEGS));
            map.put(EquipmentSlot.CHEST, this.makeAttributeMap(EquipmentSlot.CHEST));
            map.put(EquipmentSlot.HEAD, this.makeAttributeMap(EquipmentSlot.HEAD));
        });
    }

    public void reload() {
        this.slotToAttributeMap = null;
    }

    private Multimap<Attribute, AttributeModifier> makeAttributeMap(EquipmentSlot slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[slot.m_20749_()];
        double defense = this.config.getDefenseFor(slot);
        double toughness = ((Integer)this.config.toughness().get()).intValue();
        double knockbackResistance = (Double)this.config.knockbackResistance().get();
        if (defense != 0.0) {
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", defense, AttributeModifier.Operation.ADDITION));
        }
        if (toughness != 0.0) {
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", toughness, AttributeModifier.Operation.ADDITION));
        }
        if (knockbackResistance != 0.0) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor  knockback resistance", knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public static EnumMap<ArmorItem.Type, Integer> makeArmorMap(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266655_ -> {
            p_266655_.put(ArmorItem.Type.BOOTS, boots);
            p_266655_.put(ArmorItem.Type.LEGGINGS, leggings);
            p_266655_.put(ArmorItem.Type.CHESTPLATE, chestplate);
            p_266655_.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    public int m_266425_(ArmorItem.Type p_266745_) {
        return -1;
    }

    public int m_7366_(ArmorItem.Type type) {
        return -1;
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return -1.0f;
    }

    public float m_6649_() {
        return -1.0f;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
        ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    }
}

