/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatium.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ru.blatfan.blatium.ServerConfig;
import ru.blatfan.blatium.init.BlatiumToolTiers;

public class BlatiumShovel
extends ShovelItem {
    private final ServerConfig.MaterialSetConfig config = ServerConfig.BLATIUM_CONFIG;
    private static Multimap<Attribute, AttributeModifier> attribites = null;

    public BlatiumShovel() {
        super(BlatiumToolTiers.BLATIUM_TIER, 0.0f, 0.0f, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC));
    }

    private Multimap<Attribute, AttributeModifier> makeAttributeMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = UUID.randomUUID();
        double attackDamage = ((Integer)this.config.shovelDamage().get()).intValue();
        double attackSpeed = ((Float)this.config.shovelSpeed().get()).floatValue();
        if (attackDamage != 0.0) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Attack damage", attackDamage, AttributeModifier.Operation.ADDITION));
        }
        if (attackSpeed != 0.0) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(uuid, "Attack speed", attackSpeed, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public static void reload() {
        attribites = null;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (attribites == null) {
            attribites = this.makeAttributeMap();
        }
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return attribites;
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        p_41423_.add((Component)Component.m_237119_());
        p_41423_.add((Component)Component.m_237115_((String)"tooltip.blatium.unbreakable").m_130940_(ChatFormatting.LIGHT_PURPLE));
        p_41423_.add((Component)Component.m_237119_());
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
    }
}

