/*
 * Decompiled with CFR 0.152.
 */
package world.anhgelus.architectsland.difficultydeathscaler;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.anhgelus.architectsland.difficultydeathscaler.DifficultyManager;
import world.anhgelus.architectsland.difficultydeathscaler.boss.BossManager;

public class DifficultyDeathScaler
implements ModInitializer {
    public static final String MOD_ID = "difficulty-death-scaler";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"difficulty-death-scaler");

    public void onInitialize() {
        LOGGER.info("Difficulty Death Scaler started");
        DifficultyManager difficultyManager = new DifficultyManager();
        LiteralArgumentBuilder command = class_2170.method_9247((String)"difficultydeathscaler");
        command.then(class_2170.method_9247((String)"get").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            MinecraftServer server = source.method_9211();
            source.method_9226(() -> class_2561.method_43470((String)difficultyManager.getDifficultyUpdate(server, server.method_30002().method_8407())), false);
            return 1;
        }));
        command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> source.method_9259(1))).then(class_2170.method_9244((String)"number of death", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            MinecraftServer server = source.method_9211();
            difficultyManager.setNumberOfDeath(server, IntegerArgumentType.getInteger((CommandContext)context, (String)"number of death"), false);
            source.method_9226(() -> class_2561.method_43470((String)"The difficulty has been changed"), true);
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(command));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> difficultyManager.setNumberOfDeath(server, difficultyManager.getNumberOfDeath(), true));
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                difficultyManager.increaseDeath(player.field_13995);
                return;
            }
            BossManager.handleKill((class_1297)entity, difficultyManager);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> difficultyManager.applyHealthModifierToPlayer(handler.field_14140));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> difficultyManager.applyHealthModifierToPlayer(newPlayer));
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> BossManager.handleBuff(player, world, hand, entity));
    }
}

