/*
 * Decompiled with CFR 0.152.
 */
package world.anhgelus.architectsland.difficultydeathscaler;

import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1267;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class DifficultyManager {
    public static final int[] DEATH_STEPS = new int[]{0, 1, 3, 5, 7, 10, 12, 15, 17, 20};
    public final int secondsBeforeDecrease;
    private int numberOfDeath;
    private static final class_2960 HEALTH_MODIFIER_ID = class_2960.method_60654((String)"death_difficulty_health_modifier");
    private double playerHealthModifierValue = 0.0;
    private long timerStart = System.currentTimeMillis() / 1000L;
    private TimerTask reducerTask;
    private final Timer difficultyTimer = new Timer();

    public DifficultyManager() {
        this.numberOfDeath = 0;
        this.secondsBeforeDecrease = 43200;
    }

    public DifficultyManager(int numberOfDeath, int secondsBeforeDecrease, MinecraftServer server) {
        this.numberOfDeath = numberOfDeath;
        this.secondsBeforeDecrease = secondsBeforeDecrease;
        this.updateTimerTask(server);
    }

    public void setNumberOfDeath(MinecraftServer server, int n, boolean silent) {
        this.numberOfDeath = n;
        this.updateTimerTask(server);
        if (silent) {
            this.updateDeath(server, UpdateType.SILENT);
        } else {
            this.updateDeath(server, UpdateType.SET);
        }
    }

    public int getNumberOfDeath() {
        return this.numberOfDeath;
    }

    public void increaseDeath(MinecraftServer server) {
        ++this.numberOfDeath;
        this.updateDeath(server, UpdateType.INCREASE);
        this.updateTimerTask(server);
    }

    public void updateTimerTask(final MinecraftServer server) {
        if (this.reducerTask != null) {
            this.reducerTask.cancel();
        }
        if (this.numberOfDeath == 0) {
            return;
        }
        this.reducerTask = new TimerTask(){

            @Override
            public void run() {
                DifficultyManager.this.decreaseDeath(server, true);
                if (DifficultyManager.this.numberOfDeath == 0) {
                    DifficultyManager.this.reducerTask.cancel();
                }
            }
        };
        this.difficultyTimer.schedule(this.reducerTask, (long)this.secondsBeforeDecrease * 1000L, (long)this.secondsBeforeDecrease * 1000L);
        this.timerStart = System.currentTimeMillis() / 1000L;
    }

    public void decreaseDeath(MinecraftServer server) {
        if (this.numberOfDeath < DEATH_STEPS[1]) {
            this.numberOfDeath = 0;
            return;
        }
        for (int i = DEATH_STEPS.length - 1; i > 0; --i) {
            if (this.numberOfDeath < DEATH_STEPS[i]) continue;
            this.numberOfDeath = DEATH_STEPS[i - 1];
            break;
        }
        this.updateDeath(server, UpdateType.DECREASE);
    }

    public void decreaseDeath(MinecraftServer server, boolean updateTimer) {
        if (updateTimer) {
            this.timerStart = System.currentTimeMillis() / 1000L;
        }
        this.decreaseDeath(server);
    }

    private void updateDeath(@NotNull MinecraftServer server, UpdateType updateType) {
        if (updateType == UpdateType.GET) {
            throw new IllegalArgumentException("Cannot update difficulty when only getting difficulty");
        }
        class_1928 gamerules = server.method_3767();
        class_1928.class_4312 sleeping = (class_1928.class_4312)gamerules.method_20746(class_1928.field_28357);
        class_1928.class_4310 naturalRegeneration = (class_1928.class_4310)gamerules.method_20746(class_1928.field_19395);
        class_1267 difficulty = class_1267.field_5802;
        naturalRegeneration.method_20758(true, server);
        sleeping.method_35236(30, server);
        this.playerHealthModifierValue = 0.0;
        if (this.numberOfDeath >= DEATH_STEPS[1]) {
            sleeping.method_35236(70, server);
        }
        if (this.numberOfDeath >= DEATH_STEPS[2]) {
            difficulty = class_1267.field_5807;
        }
        if (this.numberOfDeath >= DEATH_STEPS[3]) {
            sleeping.method_35236(100, server);
        }
        if (this.numberOfDeath >= DEATH_STEPS[4]) {
            this.playerHealthModifierValue = -2.0;
        }
        if (this.numberOfDeath >= DEATH_STEPS[5]) {
            this.playerHealthModifierValue = -4.0;
        }
        if (this.numberOfDeath >= DEATH_STEPS[6]) {
            this.playerHealthModifierValue = -6.0;
        }
        if (this.numberOfDeath >= DEATH_STEPS[7]) {
            this.playerHealthModifierValue = -8.0;
        }
        if (this.numberOfDeath >= DEATH_STEPS[8]) {
            this.playerHealthModifierValue = -10.0;
        }
        if (this.numberOfDeath >= DEATH_STEPS[9]) {
            naturalRegeneration.method_20758(false, server);
        }
        if (Arrays.stream(DEATH_STEPS).anyMatch(x -> x == this.numberOfDeath) || updateType == UpdateType.SET) {
            server.method_3776(difficulty, true);
            if (updateType != UpdateType.SILENT) {
                server.method_3760().method_43514(class_2561.method_30163((String)this.generateDifficultyUpdate(server, difficulty, updateType)), false);
            }
            server.method_3760().method_14571().forEach(p -> {
                this.applyHealthModifierToPlayer((class_3222)p);
                if (updateType == UpdateType.INCREASE || updateType == UpdateType.SET) {
                    p.method_17356(class_3417.field_14865, class_3419.field_15256, 1.0f, 1.2f);
                } else if (updateType == UpdateType.DECREASE) {
                    p.method_17356(class_3417.field_15195, class_3419.field_15256, 1.0f, 1.0f);
                }
            });
        }
    }

    public void applyHealthModifierToPlayer(class_3222 player) {
        class_1324 healthAttributeInstance = player.method_5996(class_5134.field_23716);
        if (healthAttributeInstance != null) {
            healthAttributeInstance.method_6200(HEALTH_MODIFIER_ID);
            if (this.playerHealthModifierValue == 0.0) {
                return;
            }
            class_1322 playerHealthModifier = new class_1322(HEALTH_MODIFIER_ID, this.playerHealthModifierValue, class_1322.class_1323.field_6328);
            healthAttributeInstance.method_26837(playerHealthModifier);
        }
    }

    @NotNull
    private String generateDifficultyUpdate(@NotNull MinecraftServer server, class_1267 difficulty, UpdateType updateType) {
        class_1928 gamerules = server.method_3767();
        int percentage = ((class_1928.class_4312)gamerules.method_20746(class_1928.field_28357)).method_20763();
        boolean naturalRegeneration = ((class_1928.class_4310)gamerules.method_20746(class_1928.field_19395)).method_20753();
        double heartAmount = (20.0 + this.playerHealthModifierValue) / 2.0;
        StringBuilder sb = new StringBuilder();
        if (updateType == UpdateType.INCREASE) {
            sb.append("\u00a78============== \u00a7rDifficulty increase! \u00a78==============\u00a7r\n");
        } else if (updateType == UpdateType.DECREASE) {
            sb.append("\u00a78============== \u00a7rDifficulty decrease! \u00a78==============\u00a7r\n");
        } else if (updateType == UpdateType.SET) {
            sb.append("\u00a78=============== \u00a7rDifficulty change! \u00a78===============\u00a7r\n");
        } else {
            sb.append("\u00a78============== \u00a7rCurrent difficulty : \u00a78==============\u00a7r\n");
        }
        if (difficulty == class_1267.field_5802) {
            sb.append("Difficulty: \u00a72Normal\u00a7r");
        } else {
            sb.append("Difficulty: \u00a7cHard\u00a7r");
        }
        sb.append("\n");
        sb.append("Players sleeping percentage to skip the night: ");
        if (percentage == 30) {
            sb.append("\u00a72");
        } else if (percentage == 70) {
            sb.append("\u00a7e");
        } else {
            sb.append("\u00a7c");
        }
        sb.append(percentage).append("%\u00a7r\n");
        sb.append("Player max heart: ");
        if (heartAmount == 10.0) {
            sb.append("\u00a72");
        } else if (heartAmount >= 9.0) {
            sb.append("\u00a7e");
        } else {
            sb.append("\u00a7c");
        }
        sb.append(heartAmount).append(" \u2764\u00a7r\n");
        sb.append("Natural regeneration: ");
        if (naturalRegeneration) {
            sb.append("\u00a72On");
        } else {
            sb.append("\u00a7cOff");
        }
        sb.append("\u00a7r\n\n");
        if (this.numberOfDeath >= DEATH_STEPS[1]) {
            if (updateType != UpdateType.INCREASE) {
                sb.append("You only need to survive for \u00a76").append(DifficultyManager.printTime((long)this.secondsBeforeDecrease - System.currentTimeMillis() / 1000L + this.timerStart)).append("\u00a7r to make the difficulty decrease");
                if (updateType == UpdateType.DECREASE) {
                    sb.append(" again");
                }
                sb.append(".");
            } else {
                sb.append("If no one died for \u00a76").append(DifficultyManager.printTime((long)this.secondsBeforeDecrease - System.currentTimeMillis() / 1000L + this.timerStart)).append("\u00a7r, then the difficulty would\u2019ve decreased... But you chose your fate.");
            }
        } else {
            sb.append("The difficulty cannot get lower. Congratulations!");
        }
        sb.append("\n\u00a78=============================================\u00a7r");
        return sb.toString();
    }

    public String getDifficultyUpdate(@NotNull MinecraftServer server, class_1267 difficulty) {
        return this.generateDifficultyUpdate(server, difficulty, UpdateType.GET);
    }

    private static String printTime(long time) {
        long hours = 0L;
        if (time > 3600L) {
            hours = Math.floorDiv(time, 3600);
        }
        long minutes = 0L;
        if (hours != 0L || time > 60L) {
            minutes = Math.floorDiv(time - hours * 3600L, 60);
        }
        long seconds = (long)Math.floor(time - hours * 3600L - minutes * 60L);
        StringBuilder sb = new StringBuilder();
        if (hours != 0L) {
            sb.append(hours).append(" hours ");
        }
        if (minutes != 0L || hours != 0L) {
            sb.append(minutes).append(" minutes ");
        }
        sb.append(seconds).append(" seconds");
        return sb.toString();
    }

    private static enum UpdateType {
        INCREASE,
        DECREASE,
        GET,
        SET,
        SILENT;

    }
}

