/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.shutter.block;

import com.boyonk.shutter.block.enums.ShutterType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;

public class ShutterBlock
extends class_2248
implements class_3737 {
    private static final Map<class_2248, Set<class_2248>> CONNECTING_BLOCKS = new HashMap<class_2248, Set<class_2248>>();
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2754<class_2750> HINGE = class_2741.field_12520;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<ShutterType> TYPE = class_2754.method_11850((String)"type", ShutterType.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 WEST_SHAPE = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final class_8177 blockSetType;

    public static void addConnectingGroup(class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            CONNECTING_BLOCKS.put(block, Arrays.stream(blocks).filter(b -> b != block).collect(Collectors.toSet()));
        }
    }

    public ShutterBlock(class_8177 type, class_4970.class_2251 settings) {
        super(settings.method_9626(type.comp_1290()));
        this.blockSetType = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)class_2750.field_12588)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657(TYPE, (Comparable)((Object)ShutterType.SINGLE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, OPEN, HINGE, POWERED, TYPE, WATERLOGGED});
    }

    public class_8177 getBlockSetType() {
        return this.blockSetType;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!this.blockSetType.comp_1471()) {
            return class_1269.field_5811;
        }
        state = (class_2680)state.method_28493((class_2769)OPEN);
        world.method_8652(pos, state, 10);
        this.playOpenCloseSound((class_1297)player, world, pos, (Boolean)state.method_11654((class_2769)OPEN));
        world.method_33596((class_1297)player, (class_6880)((Boolean)state.method_11654((class_2769)OPEN) != false ? class_5712.field_28168 : class_5712.field_28169), pos);
        return class_1269.method_29236((boolean)world.field_9236);
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        boolean closed = (Boolean)state.method_11654((class_2769)OPEN) == false;
        boolean rightHinge = state.method_11654(HINGE) == class_2750.field_12586;
        return switch (facing) {
            case class_2350.field_11043 -> {
                if (closed) {
                    yield NORTH_SHAPE;
                }
                if (rightHinge) {
                    yield WEST_SHAPE;
                }
                yield EAST_SHAPE;
            }
            case class_2350.field_11034 -> {
                if (closed) {
                    yield EAST_SHAPE;
                }
                if (rightHinge) {
                    yield NORTH_SHAPE;
                }
                yield SOUTH_SHAPE;
            }
            case class_2350.field_11035 -> {
                if (closed) {
                    yield SOUTH_SHAPE;
                }
                if (rightHinge) {
                    yield EAST_SHAPE;
                }
                yield WEST_SHAPE;
            }
            case class_2350.field_11039 -> {
                if (closed) {
                    yield WEST_SHAPE;
                }
                if (rightHinge) {
                    yield SOUTH_SHAPE;
                }
                yield NORTH_SHAPE;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
        };
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        ShutterType type = (ShutterType)((Object)state.method_11654(TYPE));
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            return state;
        }
        if (ShutterBlock.shouldConnect(neighborState, state)) {
            return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)OPEN, (Comparable)((Boolean)neighborState.method_11654((class_2769)OPEN)))).method_11657((class_2769)POWERED, (Comparable)((Boolean)neighborState.method_11654((class_2769)POWERED)))).method_11657(TYPE, (Comparable)((Object)(direction == class_2350.field_11036 ? type.withUp(true) : type.withDown(true))));
        }
        return (class_2680)state.method_11657(TYPE, (Comparable)((Object)(direction == class_2350.field_11036 ? type.withUp(false) : type.withDown(false))));
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        boolean powered = world.method_49803(pos);
        if (!powered) {
            class_2680 current;
            class_2680 previous = state;
            class_2338.class_2339 neighBorPos = new class_2338.class_2339().method_10101((class_2382)pos);
            while (world.method_24794((class_2338)neighBorPos)) {
                neighBorPos.method_33098(neighBorPos.method_10264() - 1);
                current = world.method_8320((class_2338)neighBorPos);
                if (!ShutterBlock.shouldConnect(current, previous)) break;
                if (world.method_49803((class_2338)neighBorPos)) {
                    powered = true;
                    break;
                }
                previous = current;
            }
            if (!powered) {
                previous = state;
                neighBorPos.method_10101((class_2382)pos);
                while (world.method_24794((class_2338)neighBorPos)) {
                    neighBorPos.method_33098(neighBorPos.method_10264() + 1);
                    current = world.method_8320((class_2338)neighBorPos);
                    if (!ShutterBlock.shouldConnect(current, previous)) break;
                    if (world.method_49803((class_2338)neighBorPos)) {
                        powered = true;
                        break;
                    }
                    previous = current;
                }
            }
        }
        if (!this.method_9564().method_27852(sourceBlock) && powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            if (powered != (Boolean)state.method_11654((class_2769)OPEN)) {
                this.playOpenCloseSound(null, world, pos, powered);
                world.method_33596(null, (class_6880)(powered ? class_5712.field_28168 : class_5712.field_28169), pos);
            }
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    protected class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public class_1799 method_9700(@Nullable class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
        if (player == null || !player.method_7337()) {
            return class_1799.field_8037;
        }
        return super.method_9700(player, world, pos, state);
    }

    public boolean method_10310(@Nullable class_1657 player, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        if (player == null || !player.method_7337()) {
            return false;
        }
        return super.method_10310(player, world, pos, state, fluid);
    }

    protected void method_55124(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> stackMerger) {
        if (explosion.method_60274() && this.blockSetType.comp_2112() && !((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            this.setOpen(null, world, state, pos, (Boolean)state.method_11654((class_2769)OPEN) == false);
        }
        super.method_55124(state, world, pos, explosion, stackMerger);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case class_10.field_50, class_10.field_51 -> (Boolean)state.method_11654((class_2769)OPEN);
            case class_10.field_48 -> false;
        };
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state;
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        class_2350 side = ctx.method_8038();
        class_2350 facing = side.method_10166().method_10179() ? side : ctx.method_8042();
        class_2680 upState = world.method_8320(pos.method_10084());
        class_2680 downState = world.method_8320(pos.method_10074());
        if (!ctx.method_8046() && (ShutterBlock.shouldConnect(upState, downState) || ShutterBlock.isConnectingBlock(upState, this) != ShutterBlock.isConnectingBlock(downState, this))) {
            state = ShutterBlock.isConnectingBlock(upState, this) ? (class_2680)((class_2680)this.method_9564().method_11657(HINGE, (Comparable)((class_2750)upState.method_11654(HINGE)))).method_11657((class_2769)FACING, (Comparable)((class_2350)upState.method_11654((class_2769)FACING))) : (class_2680)((class_2680)this.method_9564().method_11657(HINGE, (Comparable)((class_2750)downState.method_11654(HINGE)))).method_11657((class_2769)FACING, (Comparable)((class_2350)downState.method_11654((class_2769)FACING)));
        } else {
            class_2680 againstState = world.method_8320(pos.method_10093(side.method_10153()));
            state = side.method_10166() == class_2350.class_2351.field_11052 && ShutterBlock.isConnectingBlock(againstState, this) ? (class_2680)((class_2680)this.method_9564().method_11657(HINGE, (Comparable)((class_2750)againstState.method_11654(HINGE)))).method_11657((class_2769)FACING, (Comparable)((class_2350)againstState.method_11654((class_2769)FACING))) : (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657(HINGE, (Comparable)this.getHinge(ctx, facing));
        }
        boolean up = ShutterBlock.shouldConnect(upState, state);
        boolean down = ShutterBlock.shouldConnect(downState, state);
        boolean powered = world.method_49803(pos) || up && (Boolean)upState.method_11654((class_2769)POWERED) != false || down && (Boolean)downState.method_11654((class_2769)POWERED) != false;
        boolean open = powered || up && (Boolean)upState.method_11654((class_2769)OPEN) != false || down && (Boolean)downState.method_11654((class_2769)OPEN) != false;
        boolean waterlogged = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open))).method_11657(TYPE, (Comparable)((Object)ShutterType.with(up, down)))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    private class_2750 getHinge(class_1750 ctx, class_2350 facing) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2338 upPos = pos.method_10084();
        class_2350 left = facing.method_10160();
        class_2338 leftPos = pos.method_10093(left);
        class_2680 leftState = world.method_8320(leftPos);
        class_2338 leftUpPos = upPos.method_10093(left);
        class_2680 leftUpState = world.method_8320(leftUpPos);
        class_2350 right = facing.method_10170();
        class_2338 rightPos = pos.method_10093(right);
        class_2680 rightState = world.method_8320(rightPos);
        class_2338 rightUpPos = upPos.method_10093(right);
        class_2680 rightUpState = world.method_8320(rightUpPos);
        int i = (leftState.method_26234((class_1922)world, leftPos) ? -1 : 0) + (leftUpState.method_26234((class_1922)world, leftUpPos) ? -1 : 0) + (rightState.method_26234((class_1922)world, rightPos) ? 1 : 0) + (rightUpState.method_26234((class_1922)world, rightUpPos) ? 1 : 0);
        boolean leftShutter = leftState.method_26204() instanceof ShutterBlock;
        boolean rightShutter = rightState.method_26204() instanceof ShutterBlock;
        if (leftShutter && !rightShutter || i > 0) {
            return class_2750.field_12586;
        }
        if (rightShutter && !leftShutter || i < 0) {
            return class_2750.field_12588;
        }
        int offsetX = facing.method_10148();
        int offsetZ = facing.method_10165();
        class_243 hitPos = ctx.method_17698();
        double deltaX = hitPos.field_1352 - (double)pos.method_10263();
        double deltaZ = hitPos.field_1350 - (double)pos.method_10260();
        return offsetX < 0 && deltaZ < 0.5 || offsetX > 0 && deltaZ > 0.5 || offsetZ < 0 && deltaX > 0.5 || offsetZ > 0 && deltaX < 0.5 ? class_2750.field_12586 : class_2750.field_12588;
    }

    public void setOpen(@Nullable class_1297 entity, class_1937 world, class_2680 state, class_2338 pos, boolean open) {
        if (!state.method_27852((class_2248)this) || (Boolean)state.method_11654((class_2769)OPEN) == open) {
            return;
        }
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 10);
        this.playOpenCloseSound(entity, world, pos, open);
        world.method_33596(entity, (class_6880)(open ? class_5712.field_28168 : class_5712.field_28169), pos);
    }

    private void playOpenCloseSound(@Nullable class_1297 entity, class_1937 world, class_2338 pos, boolean open) {
        world.method_45445(entity, pos, open ? this.blockSetType.comp_1294() : this.blockSetType.comp_1293(), class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);
    }

    protected boolean method_9526(class_2680 state) {
        return true;
    }

    public static boolean shouldConnect(class_2680 a, class_2680 b) {
        if (a.method_26204() != b.method_26204()) {
            if (!CONNECTING_BLOCKS.containsKey(a.method_26204())) {
                return false;
            }
            if (!CONNECTING_BLOCKS.get(a.method_26204()).contains(b.method_26204())) {
                return false;
            }
        }
        if (!(a.method_26204() instanceof ShutterBlock)) {
            return false;
        }
        return a.method_11654((class_2769)FACING) == b.method_11654((class_2769)FACING) && a.method_11654(HINGE) == b.method_11654(HINGE);
    }

    public static boolean isConnectingBlock(class_2680 state, class_2248 block) {
        if (state.method_27852(block)) {
            return true;
        }
        if (!CONNECTING_BLOCKS.containsKey(state.method_26204())) {
            return false;
        }
        return CONNECTING_BLOCKS.get(state.method_26204()).contains(block);
    }
}

