/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.shutter.data.compat;

import com.boyonk.pine.block.PineBlocks;
import com.boyonk.shutter.compat.PineCompat;
import com.boyonk.shutter.data.ShutterDataGenerator;
import com.boyonk.shutter.registry.tag.ShutterBlockTags;
import com.boyonk.shutter.registry.tag.ShutterItemTags;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1935;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_7225;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class PineCompatDataGenerator {
    public static void initialize(FabricDataGenerator.Pack pack) {
        pack.addProvider(PineCompatModelProvider::new);
        pack.addProvider(PineCompatBlockLootTableProvider::new);
        pack.addProvider(PineCompatRecipeProvider::new);
        PineCompatBlockTagProvider blockTagProvider = (PineCompatBlockTagProvider)pack.addProvider(PineCompatBlockTagProvider::new);
        pack.addProvider((output, registriesFuture) -> new PineCompatItemTagProvider(output, registriesFuture, blockTagProvider));
        pack.addProvider(PineCompatEnglishLanguageProvider::new);
        pack.addProvider(PineCompatDutchLanguageProvider::new);
    }

    private static class PineCompatBlockTagProvider
    extends FabricTagProvider.BlockTagProvider {
        public PineCompatBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.getOrCreateTagBuilder(ShutterBlockTags.WOODEN_SHUTTERS).add((Object)PineCompat.PINE_SHUTTER);
        }
    }

    private static class PineCompatItemTagProvider
    extends FabricTagProvider.ItemTagProvider {
        public PineCompatItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, @Nullable FabricTagProvider.BlockTagProvider blockTagProvider) {
            super(output, completableFuture, blockTagProvider);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.copy(ShutterBlockTags.WOODEN_SHUTTERS, ShutterItemTags.WOODEN_SHUTTERS);
        }
    }

    private static class PineCompatDutchLanguageProvider
    extends FabricLanguageProvider {
        protected PineCompatDutchLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "nl_nl", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add(PineCompat.PINE_SHUTTER, "Dennenhouten luik");
        }
    }

    private static class PineCompatEnglishLanguageProvider
    extends FabricLanguageProvider {
        protected PineCompatEnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add(PineCompat.PINE_SHUTTER, "Pine Shutter");
        }
    }

    private static class PineCompatRecipeProvider
    extends FabricRecipeProvider {
        public PineCompatRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            ShutterDataGenerator.ShutterRecipeProvider.offerShutterRecipe(exporter, (class_1935)PineCompat.PINE_SHUTTER, (class_1935)PineBlocks.PINE_PLANKS);
        }
    }

    private static class PineCompatBlockLootTableProvider
    extends FabricBlockLootTableProvider {
        protected PineCompatBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void method_10379() {
            this.method_46025(PineCompat.PINE_SHUTTER);
        }
    }

    private static class PineCompatModelProvider
    extends FabricModelProvider {
        public PineCompatModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 generator) {
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, PineCompat.PINE_SHUTTER);
        }

        public void generateItemModels(class_4915 generator) {
        }
    }
}

