/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zmiracle;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.zmiracle.init.ZmiracleModEntities;
import net.mcreator.zmiracle.init.ZmiracleModItems;
import net.mcreator.zmiracle.init.ZmiracleModMenus;
import net.mcreator.zmiracle.init.ZmiracleModMobEffects;
import net.mcreator.zmiracle.init.ZmiracleModParticleTypes;
import net.mcreator.zmiracle.init.ZmiracleModPotions;
import net.mcreator.zmiracle.init.ZmiracleModSounds;
import net.mcreator.zmiracle.init.ZmiracleModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="zmiracle")
public class ZmiracleMod {
    public static final Logger LOGGER = LogManager.getLogger(ZmiracleMod.class);
    public static final String MODID = "zmiracle";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("zmiracle", "zmiracle"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public ZmiracleMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ZmiracleModSounds.REGISTRY.register(bus);
        ZmiracleModItems.REGISTRY.register(bus);
        ZmiracleModEntities.REGISTRY.register(bus);
        ZmiracleModTabs.REGISTRY.register(bus);
        ZmiracleModMobEffects.REGISTRY.register(bus);
        ZmiracleModPotions.REGISTRY.register(bus);
        ZmiracleModParticleTypes.REGISTRY.register(bus);
        ZmiracleModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

