/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.salju.trialstowers.entity.ai.BreezeAttackGoal;
import net.salju.trialstowers.init.TrialsModSounds;

public class Breeze
extends Monster {
    private static final EntityDataAccessor<Boolean> CHARGE = SynchedEntityData.m_135353_(Breeze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cd;

    public Breeze(EntityType<Breeze> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Charging", this.isCharging());
        tag.m_128405_("Cooldown", this.cd);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(CHARGE, (Object)tag.m_128471_("Charging"));
        this.cd = tag.m_128451_("Cooldown");
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(2, (Goal)new BreezeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Projectile) {
            this.m_5496_((SoundEvent)TrialsModSounds.BREEZE_DEFLECT.get(), 1.0f, 1.0f);
            return false;
        }
        return source.m_276093_(DamageTypes.f_268671_) ? false : super.m_6469_(source, amount);
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, this.m_5448_() != null ? 0.25 : 0.5, 1.0));
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        if (this.cd > 0) {
            --this.cd;
        }
        if (this.m_5448_() != null) {
            if (this.m_20270_((Entity)this.m_5448_()) <= 4.5f && this.cd <= 0) {
                BlockPos pos = this.findPositionNear(6);
                if (pos != null) {
                    this.m_6021_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    this.m_5496_((SoundEvent)TrialsModSounds.BREEZE_SLIDE.get(), 1.0f, 1.0f);
                    this.cd = 120;
                } else {
                    this.cd = 40;
                }
            } else if (this.m_5448_().m_20188_() + 0.96 > this.m_20188_() && this.m_6779_(this.m_5448_())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - this.m_20184_().f_82480_) * (double)0.3f, 0.0));
            }
        }
        super.m_8024_();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.56f : 1.32f;
    }

    public SoundEvent m_7515_() {
        return this.m_20096_() ? (SoundEvent)TrialsModSounds.BREEZE_IDLE.get() : (SoundEvent)TrialsModSounds.BREEZE_IDLE_AIR.get();
    }

    public SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TrialsModSounds.BREEZE_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TrialsModSounds.BREEZE_DEATH.get();
    }

    public void m_7355_(BlockPos pos, BlockState state) {
    }

    @Nullable
    public BlockPos findPositionNear(int range) {
        BlockPos pos = null;
        for (int i = 0; i < 25; ++i) {
            int x = this.m_20183_().m_123341_() + this.m_217043_().m_188503_(range * 2) - range;
            int y = this.m_20183_().m_123342_() + this.m_217043_().m_188503_(range * 2) - range;
            int z = this.m_20183_().m_123343_() + this.m_217043_().m_188503_(range * 2) - range;
            BlockPos test = new BlockPos(x, y, z);
            if (!this.m_9236_().m_45772_(this.m_6095_().m_20585_((double)test.m_123341_(), (double)test.m_123342_(), (double)test.m_123343_())) || !this.canMoveTo(test) || !((double)test.m_123342_() >= this.m_20186_())) continue;
            pos = test;
            break;
        }
        if (pos != null) {
            return BlockPos.m_274561_((double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5));
        }
        return null;
    }

    public boolean canMoveTo(BlockPos pos) {
        boolean check = true;
        for (BlockPos checkpos : BlockPos.m_121940_((BlockPos)pos.m_7494_(), (BlockPos)this.m_20183_().m_7494_())) {
            BlockState checkstate = this.m_9236_().m_8055_(checkpos);
            if (!checkstate.m_60815_()) continue;
            check = false;
            break;
        }
        return check;
    }

    public void setCharged(boolean check) {
        this.m_20088_().m_135381_(CHARGE, (Object)check);
    }

    public boolean isCharging() {
        return (Boolean)this.m_20088_().m_135370_(CHARGE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }
}

