/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.entity.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.salju.trialstowers.entity.Breeze;
import net.salju.trialstowers.entity.WindCharge;
import net.salju.trialstowers.init.TrialsModSounds;

public class BreezeAttackGoal
extends Goal {
    private final Breeze brezo;
    private int attackTime;
    private int lastSeen;

    public BreezeAttackGoal(Breeze t) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.brezo = t;
    }

    public boolean m_8036_() {
        return this.brezo.m_5448_() != null && this.brezo.m_5448_().m_6084_() && this.brezo.m_6779_(this.brezo.m_5448_());
    }

    public void m_8056_() {
        this.attackTime = 0;
    }

    public void m_8041_() {
        this.brezo.setCharged(false);
        this.lastSeen = 0;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity target = this.brezo.m_5448_();
        if (target != null) {
            if (this.brezo.m_21574_().m_148306_((Entity)target)) {
                this.lastSeen = 0;
            } else {
                ++this.lastSeen;
                if (this.brezo.isCharging()) {
                    this.brezo.setCharged(false);
                }
            }
            if (this.brezo.m_20280_((Entity)target) < this.getFollowDistance() * this.getFollowDistance() && this.brezo.m_21574_().m_148306_((Entity)target)) {
                if (this.attackTime <= 0) {
                    this.attackTime = 80;
                } else if (this.attackTime == 20) {
                    this.brezo.setCharged(true);
                    this.brezo.m_5496_((SoundEvent)TrialsModSounds.BREEZE_CHARGE.get(), 1.0f, 1.0f);
                } else if (this.attackTime == 1) {
                    this.brezo.setCharged(false);
                    this.brezo.m_5496_((SoundEvent)TrialsModSounds.BREEZE_SHOOT.get(), 1.0f, 1.0f);
                    WindCharge ammo = new WindCharge(this.brezo.m_9236_(), (LivingEntity)this.brezo);
                    ammo.m_6686_(this.brezo.m_20252_((float)1.0f).f_82479_, this.brezo.m_20252_((float)1.0f).f_82480_, this.brezo.m_20252_((float)1.0f).f_82481_, 1.45f, 1.0f);
                    this.brezo.m_9236_().m_7967_((Entity)ammo);
                }
                this.brezo.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
                this.brezo.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            } else if (this.lastSeen < 5) {
                this.brezo.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            }
            super.m_8037_();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private double getFollowDistance() {
        return this.brezo.m_21133_(Attributes.f_22277_);
    }
}

