/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.FireAspectEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MaceItem
extends TieredItem
implements Vanishable {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private float damage;

    public MaceItem(Tier t, int i, float f, Item.Properties props) {
        super(t, props);
        this.attackDamage = (float)i + t.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_13038_) ? 2.5f : 1.0f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity target) {
        if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            stack.m_41622_(2, target, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState state) {
        return state.m_204336_(BlockTags.f_13038_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return ench instanceof DamageEnchantment || ench instanceof FireAspectEnchantment || super.canApplyAtEnchantingTable(stack, ench);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public float getMaceDamage(DamageSource source, LivingEntity target, int i) {
        float f1 = 1.0f - (float)i * 0.15f;
        this.damage = CombatRules.m_19272_((float)this.damage, (float)((float)target.m_21230_() * f1), (float)((float)target.m_21133_(Attributes.f_22285_) * f1));
        if (target.m_21023_(MobEffects.f_19606_)) {
            int e = (target.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5;
            this.damage = Math.max(this.damage * (25.0f - (float)e) / 25.0f, 0.0f);
        }
        this.damage = CombatRules.m_19269_((float)this.damage, (float)EnchantmentHelper.m_44856_((Iterable)target.m_6168_(), (DamageSource)source));
        return this.damage;
    }

    public void setMaceDamage(float f) {
        this.damage = f;
    }
}

