/*
 * Decompiled with CFR 0.152.
 */
package net.tctcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tctcore.network.FlashlightMenuButtonMessage;
import net.tctcore.procedures.RecupererentityFlashlightProcedure;
import net.tctcore.world.inventory.FlashlightMenuMenu;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FlashlightMenuScreen
extends AbstractContainerScreen<FlashlightMenuMenu> {
    private static final HashMap<String, Object> guistate = FlashlightMenuMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_leave;
    Button button_leave1;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"tctcore:textures/screens/flashlight_menu.png");

    public FlashlightMenuScreen(FlashlightMenuMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 500;
        this.imageHeight = 300;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = RecupererentityFlashlightProcedure.execute((LevelAccessor)this.world);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 92, this.topPos + 202, 40, 0.0f + (float)Math.atan((double)(this.leftPos + 92 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 153 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/11.png"), this.leftPos + 28, this.topPos + 47, 0.0f, 0.0f, 50, 50, 50, 50);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/craft5.png"), this.leftPos + 172, this.topPos + 200, 0.0f, 0.0f, 73, 35, 73, 35);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/craft1.png"), this.leftPos + 307, this.topPos + 65, 0.0f, 0.0f, 75, 35, 75, 35);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/craft4.png"), this.leftPos + 307, this.topPos + 200, 0.0f, 0.0f, 75, 35, 75, 35);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/craft3.png"), this.leftPos + 307, this.topPos + 119, 0.0f, 0.0f, 75, 35, 75, 35);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/craft2.png"), this.leftPos + 172, this.topPos + 119, 0.0f, 0.0f, 75, 35, 75, 35);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/description_93a90baf-2fe9-4979-9717-3d8fe86d68c6.png"), this.leftPos + 172, this.topPos + 65, 0.0f, 0.0f, 91, 19, 91, 19);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_tct_core_mods_menu"), 280, 29, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_tct_core"), 82, 47, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_by_the_tct"), 82, 83, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_flashlight"), 172, 110, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_headlamp"), 307, 110, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_lantern"), 172, 191, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_night_vision_goggle"), 307, 191, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_battery"), 307, 56, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_recharge_your_night_vision_scope"), 307, 236, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_scope_by_placing_it_in_an_anvil"), 307, 245, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_anvil_with_a_battery"), 307, 254, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_you_cannot_recharge_your_lantern"), 172, 236, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_your_lantern"), 172, 245, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_recharge_by_right_clicking_with"), 172, 155, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_with_a_battery_in_hand"), 172, 164, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_recharge_by_placing_the_headlamp"), 307, 155, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_headlamp_and_a_battery_in_an_an"), 307, 164, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_in_an_anvil"), 307, 173, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.flashlight_menu.label_by_right"), 172, 173, -12829636, false);
    }

    public void init() {
        super.init();
        this.button_leave = Button.builder((Component)Component.translatable((String)"gui.tctcore.flashlight_menu.button_leave"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new FlashlightMenuButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            FlashlightMenuButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 100, this.topPos + 245, 51, 20).build();
        guistate.put("button:button_leave", this.button_leave);
        this.addRenderableWidget((GuiEventListener)this.button_leave);
        this.button_leave1 = Button.builder((Component)Component.translatable((String)"gui.tctcore.flashlight_menu.button_leave1"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new FlashlightMenuButtonMessage(1, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            FlashlightMenuButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }).bounds(this.leftPos + 28, this.topPos + 245, 51, 20).build();
        guistate.put("button:button_leave1", this.button_leave1);
        this.addRenderableWidget((GuiEventListener)this.button_leave1);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

