/*
 * Decompiled with CFR 0.152.
 */
package net.tctcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tctcore.network.SlendermansettingsButtonMessage;
import net.tctcore.procedures.EntityslendermanProcedure;
import net.tctcore.world.inventory.SlendermansettingsMenu;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SlendermansettingsScreen
extends AbstractContainerScreen<SlendermansettingsMenu> {
    private static final HashMap<String, Object> guistate = SlendermansettingsMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_leave;
    Button button_leave1;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"tctcore:textures/screens/slendermansettings.png");

    public SlendermansettingsScreen(SlendermansettingsMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 500;
        this.imageHeight = 300;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = EntityslendermanProcedure.execute((LevelAccessor)this.world);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 92, this.topPos + 220, 40, 0.0f + (float)Math.atan((double)(this.leftPos + 92 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 171 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/15.png"), this.leftPos + 28, this.topPos + 47, 0.0f, 0.0f, 50, 50, 50, 50);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/slender1.png"), this.leftPos + 325, this.topPos + 74, 0.0f, 0.0f, 100, 113, 100, 113);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/slender2.png"), this.leftPos + 181, this.topPos + 74, 0.0f, 0.0f, 96, 115, 96, 115);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/slenderpickaxe.png"), this.leftPos + 433, this.topPos + 236, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"tctcore:textures/screens/slendersword.png"), this.leftPos + 433, this.topPos + 218, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_tct_core_mods_menu"), 289, 29, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_tct_core"), 82, 47, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_by_the_tct"), 82, 83, -16777216, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_look_for_the_8_pages_in_your_wor"), 172, 47, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_the_more_you_find_the_more_viol"), 172, 56, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_once_you_find_the_8_pages_you_wi"), 172, 218, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_rewards_a_pickaxe_a_sword_and"), 172, 236, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_the_slenderman_will_not_appear_u"), 172, 200, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.tctcore.slendermansettings.label_its_up_to_you_to_discover_what"), 172, 254, -12829636, false);
    }

    public void init() {
        super.init();
        this.button_leave = Button.builder((Component)Component.translatable((String)"gui.tctcore.slendermansettings.button_leave"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SlendermansettingsButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SlendermansettingsButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 100, this.topPos + 245, 51, 20).build();
        guistate.put("button:button_leave", this.button_leave);
        this.addRenderableWidget((GuiEventListener)this.button_leave);
        this.button_leave1 = Button.builder((Component)Component.translatable((String)"gui.tctcore.slendermansettings.button_leave1"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SlendermansettingsButtonMessage(1, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SlendermansettingsButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }).bounds(this.leftPos + 28, this.topPos + 245, 51, 20).build();
        guistate.put("button:button_leave1", this.button_leave1);
        this.addRenderableWidget((GuiEventListener)this.button_leave1);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

