/*
 * Decompiled with CFR 0.152.
 */
package net.tctcore.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tctcore.TctcoreMod;
import net.tctcore.procedures.MainmenutctcoreProcedure;
import net.tctcore.procedures.OuvrirMflashlightProcedure;
import net.tctcore.procedures.OuvrirShowFPSProcedure;
import net.tctcore.procedures.OuvrirclearlagProcedure;
import net.tctcore.procedures.OuvrireherobrineProcedure;
import net.tctcore.procedures.OuvrirmenuFPSBOOSTProcedure;
import net.tctcore.procedures.OuvrirmenuFlashlightProcedure;
import net.tctcore.procedures.OuvrirmenuMatmosProcedure;
import net.tctcore.procedures.OuvrirmenuTCTCoreProcedure;
import net.tctcore.procedures.OuvrirmenucameracraftProcedure;
import net.tctcore.procedures.OuvrirpaladiumProcedure;
import net.tctcore.procedures.OuvrirslendermanProcedure;
import net.tctcore.world.inventory.ModsSettingsMenuMenu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ModsSettingsMenuButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ModsSettingsMenuButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tctcore", (String)"mods_settings_menu_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ModsSettingsMenuButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ModsSettingsMenuButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ModsSettingsMenuButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(ModsSettingsMenuButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                ModsSettingsMenuButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = ModsSettingsMenuMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MainmenutctcoreProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OuvrirmenuFPSBOOSTProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            OuvrirmenuTCTCoreProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OuvrirmenuFlashlightProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OuvrirmenuMatmosProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            OuvrireherobrineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            OuvrirclearlagProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            OuvrirmenucameracraftProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            OuvrirpaladiumProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            OuvrirslendermanProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            OuvrirMflashlightProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            OuvrirShowFPSProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TctcoreMod.addNetworkMessage(TYPE, STREAM_CODEC, ModsSettingsMenuButtonMessage::handleData);
    }
}

