/*
 * Decompiled with CFR 0.152.
 */
package net.tctcore.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tctcore.TctcoreMod;
import net.tctcore.procedures.ApplycheckboxProcedure;
import net.tctcore.procedures.CameracraftwebsiteProcedure;
import net.tctcore.procedures.ClearlagwebProcedure;
import net.tctcore.procedures.FPSboostwebProcedure;
import net.tctcore.procedures.FlashlightWebsiteProcedure;
import net.tctcore.procedures.GussdxdecowebProcedure;
import net.tctcore.procedures.HerobrinewebsiteProcedure;
import net.tctcore.procedures.MainmenutctcoreProcedure;
import net.tctcore.procedures.MatmosWebsiteProcedure;
import net.tctcore.procedures.MflashlightWebProcedure;
import net.tctcore.procedures.ModssettingsButtonProcedure;
import net.tctcore.procedures.NicknameWebProcedure;
import net.tctcore.procedures.OuvrirshopProcedure;
import net.tctcore.procedures.PaladiumwebsiteProcedure;
import net.tctcore.procedures.SethomewebProcedure;
import net.tctcore.procedures.ShowFPSWebsiteProcedure;
import net.tctcore.procedures.SlendermanwebsiteProcedure;
import net.tctcore.procedures.WindowscomputerProcedure;
import net.tctcore.world.inventory.VingtetunMenu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record VingtetunButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VingtetunButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tctcore", (String)"vingtetun_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, VingtetunButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new VingtetunButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<VingtetunButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(VingtetunButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                VingtetunButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = VingtetunMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OuvrirshopProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ModssettingsButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            MainmenutctcoreProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ApplycheckboxProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 4) {
            FlashlightWebsiteProcedure.execute();
        }
        if (buttonID == 5) {
            SlendermanwebsiteProcedure.execute();
        }
        if (buttonID == 6) {
            MatmosWebsiteProcedure.execute();
        }
        if (buttonID == 7) {
            FPSboostwebProcedure.execute();
        }
        if (buttonID == 8) {
            SethomewebProcedure.execute();
        }
        if (buttonID == 9) {
            NicknameWebProcedure.execute();
        }
        if (buttonID == 10) {
            ClearlagwebProcedure.execute();
        }
        if (buttonID == 11) {
            CameracraftwebsiteProcedure.execute();
        }
        if (buttonID == 12) {
            HerobrinewebsiteProcedure.execute();
        }
        if (buttonID == 13) {
            PaladiumwebsiteProcedure.execute();
        }
        if (buttonID == 14) {
            GussdxdecowebProcedure.execute();
        }
        if (buttonID == 15) {
            ShowFPSWebsiteProcedure.execute();
        }
        if (buttonID == 16) {
            MflashlightWebProcedure.execute();
        }
        if (buttonID == 17) {
            WindowscomputerProcedure.execute();
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TctcoreMod.addNetworkMessage(TYPE, STREAM_CODEC, VingtetunButtonMessage::handleData);
    }
}

