/*
 * Decompiled with CFR 0.152.
 */
package net.gardenbotanical.block.entity;

import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.gardenbotanical.block.ColorizerBlock;
import net.gardenbotanical.block.GardenBotanicalBlocks;
import net.gardenbotanical.block.entity.GardenBotanicalBlockEntities;
import net.gardenbotanical.item.GardenBotanicalItems;
import net.gardenbotanical.network.GardenBotanicalNetwork;
import net.gardenbotanical.network.packet.S2C.InventorySyncPacket;
import net.gardenbotanical.tag.GardenBotanicalTags;
import net.gardenbotanical.util.Utils;
import net.gardenbotanical.util.interfaces.InventoryInterface;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ColorizerBlockEntity
extends class_2586
implements GeoBlockEntity,
InventoryInterface {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    public static final int INPUT_SLOT_ITEM = 0;
    public static final int INPUT_SLOT_DYE = 1;
    public static final int OUTPUT_SLOT_ITEM = 2;
    private int progress = 0;
    private int maxProgress = 167;

    public ColorizerBlockEntity(class_2338 pos, class_2680 state) {
        super(GardenBotanicalBlockEntities.COLORIZER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return side == class_2350.field_11033 && slot == 2;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{2};
        }
        return new int[0];
    }

    @Override
    public void method_11007(class_2487 nbt) {
        InventoryInterface.super.method_11007(nbt);
        nbt.method_10569("progress", this.progress);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        InventoryInterface.super.method_11014(nbt);
        this.progress = nbt.method_10550("progress");
    }

    public void updateClientData() {
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016())) {
            GardenBotanicalNetwork.INVENTORY_SYNC_PACKET.send(player, InventorySyncPacket.write(this.inventory, this.method_11016()));
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        this.updateClientData();
        if (!this.slotIsEmpty(0) && !this.slotIsEmpty(1)) {
            if (this.hasRecipe()) {
                this.setProcessState(state, true);
                ColorizerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.progress >= this.maxProgress) {
                    this.craftArmor();
                    this.resetProgress(state);
                }
            } else {
                this.resetProgress(state);
            }
        } else {
            this.resetProgress(state);
            ColorizerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private boolean hasRecipe() {
        return this.method_5438(0).method_31573(GardenBotanicalTags.COLORIZER_ITEM_TYPES) && this.method_5438(1).method_31574(GardenBotanicalItems.DYE) && this.slotIsEmpty(2);
    }

    private void craftArmor() {
        int outputColorItem = Utils.checkDisplayColorNbt(this.method_5438(0), 10511680) != 10511680 ? Utils.blendColors(Utils.checkDisplayColorNbt(this.method_5438(0), 10511680), Utils.checkDisplayColorNbt(this.method_5438(1), 0xFFFFFF)) : Utils.checkDisplayColorNbt(this.method_5438(1), 0xFFFFFF);
        class_1799 outputItem = this.method_5438(0).method_7972();
        this.method_5441(0);
        this.method_5441(1);
        class_2487 nbtOutputItem = outputItem.method_7911("display");
        nbtOutputItem.method_10569("color", outputColorItem);
        this.method_5447(2, outputItem);
    }

    private void setProcessState(class_2680 state, boolean value) {
        ++this.progress;
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)ColorizerBlock.PROCESS, (Comparable)Boolean.valueOf(value)));
        }
    }

    private void resetProgress(class_2680 state) {
        this.setProcessState(state, false);
        this.progress = 0;
    }

    public class_1799 getItemRender() {
        if (!this.slotIsEmpty(0)) {
            return this.method_5438(0);
        }
        if (!this.slotIsEmpty(2)) {
            return this.method_5438(2);
        }
        return class_1799.field_8037;
    }

    public boolean renderFluid() {
        return !this.slotIsEmpty(1);
    }

    public int getFluidColor() {
        return Utils.checkDisplayColorNbt(this.method_5438(1), 0xFFFFFF);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            class_2680 blockState;
            if (((ColorizerBlockEntity)state.getAnimatable()).field_11863 != null && (blockState = ((ColorizerBlockEntity)state.getAnimatable()).field_11863.method_8320(((ColorizerBlockEntity)state.getAnimatable()).field_11867)).method_27852(GardenBotanicalBlocks.COLORIZER) && ((Boolean)blockState.method_11654((class_2769)ColorizerBlock.PROCESS)).booleanValue()) {
                state.setAnimation(RawAnimation.begin().then("process", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

