/*
 * Decompiled with CFR 0.152.
 */
package net.gardenbotanical.block.entity;

import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.gardenbotanical.block.DyeMixerBlock;
import net.gardenbotanical.block.GardenBotanicalBlocks;
import net.gardenbotanical.block.entity.GardenBotanicalBlockEntities;
import net.gardenbotanical.item.GardenBotanicalItems;
import net.gardenbotanical.network.GardenBotanicalNetwork;
import net.gardenbotanical.network.packet.S2C.FluidStorageSyncPacket;
import net.gardenbotanical.network.packet.S2C.InventorySyncPacket;
import net.gardenbotanical.recipe.DyeMixerRecipe;
import net.gardenbotanical.util.FluidStack;
import net.gardenbotanical.util.Utils;
import net.gardenbotanical.util.interfaces.FluidStorageInterface;
import net.gardenbotanical.util.interfaces.InventoryInterface;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class DyeMixerBlockEntity
extends class_2586
implements GeoBlockEntity,
InventoryInterface,
FluidStorageInterface {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return FluidStack.convertDropletsToMb(81000L);
        }

        protected void onFinalCommit() {
            DyeMixerBlockEntity.this.method_5431();
        }

        protected boolean canInsert(FluidVariant variant) {
            return variant.isOf((Object)class_3612.field_15910);
        }

        protected boolean canExtract(FluidVariant variant) {
            return variant.isOf((Object)class_3612.field_15910);
        }
    };
    public static final int INPUT_SLOT_POWDER = 0;
    public static final int INPUT_SLOT_FIRST_DYE = 1;
    public static final int INPUT_SLOT_SECOND_DYE = 2;
    public static final int OUTPUT_SLOT_DYE = 3;
    private int progress = 0;
    private int maxProgress = 100;

    public DyeMixerBlockEntity(class_2338 pos, class_2680 state) {
        super(GardenBotanicalBlockEntities.DYE_MIXER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public SingleVariantStorage<FluidVariant> getFluidStorage() {
        return this.fluidStorage;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return side == class_2350.field_11033 && slot == 3;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{3};
        }
        return new int[0];
    }

    @Override
    public void method_11007(class_2487 nbt) {
        InventoryInterface.super.method_11007(nbt);
        FluidStorageInterface.super.method_11007(nbt);
        nbt.method_10569("progress", this.progress);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        InventoryInterface.super.method_11014(nbt);
        FluidStorageInterface.super.method_11014(nbt);
        this.progress = nbt.method_10550("progress");
    }

    private void updateClientData() {
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016())) {
            GardenBotanicalNetwork.INVENTORY_SYNC_PACKET.send(player, InventorySyncPacket.write(this.inventory, this.method_11016()));
            GardenBotanicalNetwork.FLUID_STORAGE_SYNC_PACKET.send(player, FluidStorageSyncPacket.write(this.fluidStorage, this.method_11016()));
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        this.updateClientData();
        if (this.fluidIsFull()) {
            if (this.hasRecipe()) {
                this.setProcessState(state, true);
                DyeMixerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.progress >= this.maxProgress) {
                    this.extractFluid();
                    this.craftItem();
                    this.resetProgress(state);
                }
            } else if (this.hasDyeRecipe()) {
                this.setProcessState(state, true);
                DyeMixerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.progress >= this.maxProgress) {
                    this.extractFluid();
                    this.mixDyes();
                    this.resetProgress(state);
                }
            } else {
                this.resetProgress(state);
            }
        } else {
            this.resetProgress(state);
            DyeMixerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private void craftItem() {
        Optional<DyeMixerRecipe> recipe = this.getCurrentRecipe();
        this.method_5441(0);
        this.method_5447(3, recipe.get().method_8110(null));
    }

    private void mixDyes() {
        int outputColorDye = Utils.blendColors(Utils.checkDisplayColorNbt(this.method_5438(1), 0xFFFFFF), Utils.checkDisplayColorNbt(this.method_5438(2), 0xFFFFFF));
        this.method_5441(1);
        this.method_5441(2);
        class_1799 outputDye = new class_1799((class_1935)GardenBotanicalItems.DYE);
        class_2487 nbtOutputDye = outputDye.method_7948();
        class_2487 nbt = new class_2487();
        nbt.method_10569("color", outputColorDye);
        nbtOutputDye.method_10566("display", (class_2520)nbt);
        this.method_5447(3, outputDye);
    }

    private boolean hasDyeRecipe() {
        return !this.slotIsEmpty(1) && !this.slotIsEmpty(2);
    }

    private boolean hasRecipe() {
        Optional<DyeMixerRecipe> recipe = this.getCurrentRecipe();
        return recipe.isPresent() && this.canInsertItem(recipe.get().method_8110(null), 3);
    }

    private Optional<DyeMixerRecipe> getCurrentRecipe() {
        class_1277 inv = new class_1277(this.method_5439());
        for (int i = 0; i < this.method_5439(); ++i) {
            if (i == 1 || i == 2) continue;
            inv.method_5447(i, this.method_5438(i));
        }
        return this.field_11863.method_8433().method_8132((class_3956)DyeMixerRecipe.Type.INSTANCE, (class_1263)inv, this.field_11863);
    }

    private void setProcessState(class_2680 state, boolean value) {
        ++this.progress;
        if (value) {
            class_2540 data = PacketByteBufs.create();
            data.method_10807(this.field_11867);
            for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016())) {
                GardenBotanicalNetwork.SPAWN_PARTICLE_PACKET.send(player, data);
            }
        }
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)DyeMixerBlock.PROCESS, (Comparable)Boolean.valueOf(value)));
        }
    }

    private void resetProgress(class_2680 state) {
        this.setProcessState(state, false);
        this.progress = 0;
    }

    public int getFluidColor() {
        if (!this.slotIsEmpty(3)) {
            return Utils.checkDisplayColorNbt(this.method_5438(3), 0xFFFFFF);
        }
        return -1;
    }

    public boolean renderFluid() {
        return this.fluidIsFull() || !this.slotIsEmpty(3);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            class_2680 blockState;
            if (((DyeMixerBlockEntity)state.getAnimatable()).field_11863 != null && (blockState = ((DyeMixerBlockEntity)state.getAnimatable()).field_11863.method_8320(((DyeMixerBlockEntity)state.getAnimatable()).field_11867)).method_27852(GardenBotanicalBlocks.DYE_MIXER) && ((Boolean)blockState.method_11654((class_2769)DyeMixerBlock.PROCESS)).booleanValue()) {
                state.setAnimation(RawAnimation.begin().then("process", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

