/*
 * Decompiled with CFR 0.152.
 */
package net.gardenbotanical.util.interfaces;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.gardenbotanical.util.FluidStack;
import net.minecraft.class_2487;
import net.minecraft.class_3609;
import net.minecraft.class_3611;

public interface FluidStorageInterface {
    public SingleVariantStorage<FluidVariant> getFluidStorage();

    default public void setFluidLevel(FluidVariant fluidVariant, long fluidLevel) {
        SingleVariantStorage<FluidVariant> fluidStorage = this.getFluidStorage();
        fluidStorage.variant = fluidVariant;
        fluidStorage.amount = fluidLevel;
    }

    default public boolean fluidIsFull() {
        SingleVariantStorage<FluidVariant> fluidStorage = this.getFluidStorage();
        return fluidStorage.amount == fluidStorage.getCapacity();
    }

    default public void fillFluid(FluidVariant variant, long amountMb) {
        try (Transaction transaction = Transaction.openOuter();){
            this.getFluidStorage().insert((TransferVariant)variant, amountMb, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    default public void fillFluid(class_3609 fluid, long amountDroplets) {
        this.fillFluid(FluidVariant.of((class_3611)fluid), FluidStack.convertDropletsToMb(amountDroplets));
    }

    default public void extractFluid(long amount) {
        SingleVariantStorage<FluidVariant> fluidStorage = this.getFluidStorage();
        try (Transaction transaction = Transaction.openOuter();){
            fluidStorage.extract((TransferVariant)((FluidVariant)fluidStorage.variant), amount, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    default public void extractFluid() {
        this.extractFluid(81000L);
    }

    default public void method_11007(class_2487 nbt) {
        this.getFluidStorage().writeNbt(nbt);
    }

    default public void method_11014(class_2487 nbt) {
        SingleVariantStorage<FluidVariant> fluidStorage = this.getFluidStorage();
        fluidStorage.variant = FluidVariant.fromNbt((class_2487)((class_2487)nbt.method_10580("variant")));
        fluidStorage.amount = nbt.method_10537("amount");
    }
}

