/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESEntityType;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public final class BuiltinHudElements {
    public static int renderEntityName(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud) {
            if (!(TESAPI.getConfig().inWorldHudEntityName() || TESConstants.CONFIG.inWorldHudNameOverride() && entity.hasCustomName())) {
                return 0;
            }
            TESClientUtil.centerTextForRender(entity.getDisplayName(), 0.0f, 0.0f, (x, y) -> TESAPI.getConfig().inWorldHudEntityNameFontStyle().render(mc.font, guiGraphics.pose(), entity.getDisplayName(), x.floatValue(), y.floatValue(), FastColor.ARGB32.color((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.bufferSource()));
        } else {
            if (!TESAPI.getConfig().hudEntityName()) {
                return 0;
            }
            TESAPI.getConfig().hudEntityNameFontStyle().render(mc.font, guiGraphics.pose(), entity.getDisplayName(), 0.0f, 0.0f, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255), guiGraphics.bufferSource());
        }
        TESEntityTracking.markNameRendered(entity);
        guiGraphics.bufferSource().endLastBatch();
        Objects.requireNonNull(mc.font);
        return 9;
    }

    public static int renderEntityHealth(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean inWorldHud) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null) {
            return 0;
        }
        TESConfig config = TESAPI.getConfig();
        int barWidth = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        TESHud.BarRenderType renderType = inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, inWorldHud ? 4.0f : 1.0f, 0.0f);
        if (inWorldHud) {
            poseStack.translate((float)barWidth * -0.5f, 0.0f, 0.0f);
            poseStack.scale(1.0f, 1.0f, -1.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        RenderSystem.enableDepthTest();
        if (renderType != TESHud.BarRenderType.NUMERIC) {
            float percentHealth = entityState.getHealth() / entity.getMaxHealth();
            float percentTransitionHealth = entityState.getLastTransitionHealth() / entity.getMaxHealth();
            boolean doSegments = inWorldHud ? config.inWorldBarsSegments() : config.hudHealthBarSegments();
            TESEntityType entityType = TESConstants.UTILS.getEntityType(entity);
            TextureAtlasSprite backgroundSprite = TESClientUtil.getAtlasSprite(entityType.backgroundTexture());
            TextureAtlasSprite progressSprite = TESClientUtil.getAtlasSprite(entityType.overlayTexture());
            TextureAtlasSprite emptyBarSprite = TESClientUtil.getAtlasSprite(TESClientUtil.BAR_EMPTY);
            TESClientUtil.prepRenderForTexture(backgroundSprite.atlasLocation());
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, emptyBarSprite, 1.0f, false, opacity);
            poseStack.translate(0.0f, 0.0f, 0.001f);
            if (percentTransitionHealth > percentHealth) {
                TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, backgroundSprite, entityState.getLastTransitionHealth() / entity.getMaxHealth(), false, opacity);
            }
            poseStack.translate(0.0f, 0.0f, 0.001f);
            RenderSystem.enableBlend();
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, progressSprite, percentHealth, doSegments, opacity);
        }
        if (renderType != TESHud.BarRenderType.BAR) {
            String healthText = TESUtil.roundToDecimal(entityState.getHealth(), 1) + "/" + TESUtil.roundToDecimal(entity.getMaxHealth(), 1);
            float halfTextWidth = (float)mc.font.width(healthText) / 2.0f;
            float center = (float)barWidth / 2.0f;
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            poseStack.translate(0.0f, 0.0f, 0.001f);
            TESClientUtil.drawColouredSquare(guiGraphics, (int)(center - halfTextWidth - 1.0f), -2, (int)(halfTextWidth * 2.0f) + 1, 9, 0x90909 | (int)(opacity * 255.0f * TESConstants.CONFIG.hudBarFontBackingOpacity()) << 24);
            poseStack.translate(0.0f, 0.0f, 0.001f);
            (inWorldHud ? TESAPI.getConfig().inWorldHudHealthFontStyle() : TESAPI.getConfig().hudHealthFontStyle()).render(mc.font, guiGraphics.pose(), (Component)Component.literal((String)healthText), center - halfTextWidth, -1.0f, FastColor.ARGB32.color((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.bufferSource());
        }
        poseStack.popPose();
        Objects.requireNonNull(mc.font);
        return 9;
    }

    public static int renderEntityArmour(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudArmour() : !TESAPI.getConfig().hudArmour()) {
            return 0;
        }
        int armour = TESUtil.getArmour(entity);
        if (armour <= 0) {
            return 0;
        }
        float toughness = TESUtil.getArmourToughness(entity);
        int textColour = FastColor.ARGB32.color((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255);
        PoseStack poseStack = guiGraphics.pose();
        TextureAtlasSprite armourSprite = TESClientUtil.getAtlasSprite(TESClientUtil.STAT_ARMOUR);
        TextureAtlasSprite toughnessSprite = TESClientUtil.getAtlasSprite(TESClientUtil.STAT_TOUGHNESS);
        poseStack.pushPose();
        if (inWorldHud) {
            int totalWidth = toughness > 0.0f ? 43 + mc.font.width("x" + TESUtil.roundToDecimal(toughness, 1)) : mc.font.width("x" + armour) + 10;
            poseStack.translate((float)totalWidth * -0.5f, 0.0f, 0.0f);
        }
        TESClientUtil.prepRenderForTexture(armourSprite.atlasLocation());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        TESClientUtil.drawSprite(guiGraphics, armourSprite, 0, 0, 9, 9, 0, 0, 9, 9, 9, 9);
        if (toughness > 0.0f) {
            TESClientUtil.drawSprite(guiGraphics, toughnessSprite, 33, 0, 9, 9, 0, 0, 9, 9, 9, 9);
        }
        (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.font, guiGraphics.pose(), (Component)Component.literal((String)("x" + armour)), 9.5f, 1.0f, textColour, guiGraphics.bufferSource());
        if (toughness > 0.0f) {
            (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.font, guiGraphics.pose(), (Component)Component.literal((String)("x" + TESUtil.roundToDecimal(toughness, 1))), 43.0f, 1.0f, textColour, guiGraphics.bufferSource());
        }
        poseStack.popPose();
        Objects.requireNonNull(mc.font);
        return 9;
    }

    public static int renderEntityIcons(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudEntityIcons() : !TESAPI.getConfig().hudEntityIcons()) {
            return 0;
        }
        int x = 0;
        TESClientUtil.prepRenderForTexture(TESClientUtil.SPRITES_ATLAS);
        for (TESHudEntityIcon icon : TESHud.getEntityIcons()) {
            if (!icon.renderIfApplicable(guiGraphics, entity, x, 0)) continue;
            x += 9;
        }
        return x == 0 ? 0 : 8;
    }

    public static int renderEntityEffects(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudPotionIcons() : !TESAPI.getConfig().hudPotionIcons()) {
            return 0;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || entityState.getEffects().isEmpty()) {
            return 0;
        }
        int effectsSize = entityState.getEffects().size();
        MobEffectTextureManager textureManager = mc.getMobEffectTextures();
        int barLength = inWorldHud ? TESAPI.getConfig().inWorldBarsLength() : TESAPI.getConfig().hudHealthBarLength();
        float maxX = (float)barLength * 2.0f;
        int iconsPerRow = (int)Math.floor(maxX / 18.0f);
        int rows = (int)Math.ceil((float)effectsSize / (float)iconsPerRow);
        int x = inWorldHud ? Math.min(effectsSize, iconsPerRow) * -9 : 0;
        int y = 0;
        int i = 0;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        poseStack.scale(0.5f, 0.5f, 1.0f);
        if (inWorldHud) {
            poseStack.translate(0.0, Math.floor((float)(effectsSize * 18) / maxX) * -18.0, 0.0);
        }
        for (Holder<MobEffect> effect : entityState.getEffects()) {
            TextureAtlasSprite sprite = textureManager.get(effect);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
            guiGraphics.blit(i * 18 + x, y, 0, 18, 18, sprite);
            if (++i < iconsPerRow) continue;
            i = 0;
            if (!inWorldHud || (y += 18) / 18 != rows - 1) continue;
            x = effectsSize % iconsPerRow % iconsPerRow * -9;
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
        return (int)Math.ceil((float)effectsSize / (float)iconsPerRow) * 9;
    }

    public static int renderHorseStats(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean inWorldHud) {
        AbstractChestedHorse chestedHorse;
        boolean hasChest;
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudHorseStats() : !TESAPI.getConfig().hudHorseStats()) {
            return 0;
        }
        if (!(entity instanceof AbstractHorse)) {
            return 0;
        }
        AbstractHorse horse = (AbstractHorse)entity;
        boolean bl = hasChest = entity instanceof AbstractChestedHorse && (chestedHorse = (AbstractChestedHorse)entity).hasChest();
        int x = inWorldHud ? (hasChest ? -18 : -11) : 1;
        guiGraphics.drawString(mc.font, "H", x, 1, Mth.hsvToArgb((float)Mth.clamp((float)(0.35f * ((float)horse.getAttributeBaseValue(Attributes.MAX_HEALTH) - AbstractHorse.MIN_HEALTH) / (AbstractHorse.MAX_HEALTH - AbstractHorse.MIN_HEALTH)), (float)0.0f, (float)0.35f), (float)1.0f, (float)1.0f, (int)255), false);
        guiGraphics.drawString(mc.font, "S", x + 8, 1, Mth.hsvToArgb((float)Mth.clamp((float)(0.35f * ((float)horse.getAttributeBaseValue(Attributes.MOVEMENT_SPEED) - AbstractHorse.MIN_MOVEMENT_SPEED) / (AbstractHorse.MAX_MOVEMENT_SPEED - AbstractHorse.MIN_MOVEMENT_SPEED)), (float)0.0f, (float)0.35f), (float)1.0f, (float)1.0f, (int)255), false);
        guiGraphics.drawString(mc.font, "J", x + 16, 1, Mth.hsvToArgb((float)Mth.clamp((float)(0.35f * ((float)horse.getAttributeBaseValue(Attributes.JUMP_STRENGTH) - AbstractHorse.MIN_JUMP_STRENGTH) / (AbstractHorse.MAX_JUMP_STRENGTH - AbstractHorse.MIN_JUMP_STRENGTH)), (float)0.0f, (float)0.35f), (float)1.0f, (float)1.0f, (int)255), false);
        if (hasChest) {
            TESClientUtil.prepRenderForTexture(TESClientUtil.SPRITES_ATLAS);
            TESClientUtil.drawSprite(guiGraphics, TESClientUtil.getAtlasSprite(TESClientUtil.PROPERTY_STORAGE), x + 24, 1, 8, 8, 0, 0, 36, 36, 36, 36);
        }
        return 9;
    }
}

