/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.networking.packet;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.particle.TESParticleManager;

public record ParticleClaimPacket(int entityId, ResourceLocation claimantId, Optional<CompoundTag> data) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<ParticleClaimPacket> TYPE = new CustomPacketPayload.Type(TESConstants.id("particle_claim"));
    public static final StreamCodec<FriendlyByteBuf, ParticleClaimPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ParticleClaimPacket::entityId, (StreamCodec)ResourceLocation.STREAM_CODEC, ParticleClaimPacket::claimantId, (StreamCodec)ByteBufCodecs.OPTIONAL_COMPOUND_TAG, ParticleClaimPacket::data, ParticleClaimPacket::new);

    public CustomPacketPayload.Type<ParticleClaimPacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> TESParticleManager.addParticleClaim(this.entityId, this.claimantId, this.data));
    }
}

