/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle.type;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.mixin.client.GuiGraphicsAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ComponentParticle
extends GenericTESParticle<Component> {
    protected Component contents;

    public ComponentParticle(@Nullable EntityState entityState, Vector3f position, Component contents) {
        this(entityState, position, TESParticle.Animation.POP_OFF, contents);
    }

    public ComponentParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, Component contents) {
        this(entityState, position, animation, contents, TESConstants.CONFIG.defaultParticleLifespan());
    }

    public ComponentParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, Component contents, int lifespan) {
        super(entityState, position, animation, lifespan);
        this.updateData(contents);
    }

    @Override
    public void updateData(Component data) {
        this.contents = data;
    }

    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, Font fontRenderer, float partialTick) {
        this.defaultedTextRender(mc, guiGraphics.pose(), this.prevPos, this.pos, partialTick, () -> TESClientUtil.centerTextForRender(this.contents, 0.0f, 0.0f, (x, y) -> TESAPI.getConfig().particleFontStyle().render(fontRenderer, guiGraphics.pose(), this.contents, x.floatValue(), y.floatValue(), 0xFFFFFF, guiGraphics.bufferSource())));
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }
}

