/*
 * Decompiled with CFR 0.152.
 */
package org.hook.mod.client.renderer.entity.hook;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.hook.mod.client.model.entity.hook.BaseHookModel;
import org.hook.mod.entity.hook.AbstractHookEntity;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHookRenderer<T extends AbstractHookEntity>
extends EntityRenderer<T> {
    protected final EntityModel<? extends AbstractHookEntity> model;
    protected final BlockRenderDispatcher dispatcher;

    public AbstractHookRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new BaseHookModel(pContext.m_174023_(BaseHookModel.LAYER_LOCATION));
        this.dispatcher = pContext.m_234597_();
    }

    public AbstractHookRenderer(EntityRendererProvider.Context pContext, EntityModel<? extends AbstractHookEntity> model) {
        super(pContext);
        this.model = model;
        this.dispatcher = pContext.m_234597_();
    }

    public abstract BlockState getChain(T var1);

    public boolean shouldRender(@NotNull T entity, @NotNull Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        if (super.m_5523_(entity, pCamera, pCamX, pCamY, pCamZ)) {
            return true;
        }
        Entity owner = entity.m_19749_();
        if (owner != null) {
            Vec3 vec3 = owner.m_20182_().m_82520_(0.0, (double)owner.m_20206_() * 0.65, 0.0);
            Vec3 vec31 = entity.m_20182_().m_82520_(0.0, 0.25, 0.0);
            return pCamera.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        int skyLight = LightTexture.m_109885_((int)10, (int)LightTexture.m_109894_((int)packedLight));
        this.renderHook(entity, poseStack, multiBufferSource, skyLight);
        Entity owner = entity.m_19749_();
        if (owner != null) {
            poseStack.m_85836_();
            Vec3 vec3 = AbstractHookRenderer.getPosition(owner, (double)owner.m_20206_() * 0.65, partialTick);
            Vec3 vec31 = AbstractHookRenderer.getPosition(entity, 0.25, partialTick);
            Vec3 vec32 = vec3.m_82546_(vec31).m_82541_();
            poseStack.m_252781_(Axis.f_252436_.m_252961_(1.5707964f - (float)Math.atan2(vec32.f_82481_, vec32.f_82479_)));
            poseStack.m_252781_(Axis.f_252529_.m_252961_((float)Math.acos(vec32.f_82480_)));
            poseStack.m_85837_(-0.5, 0.0, -0.75);
            float distance = entity.m_20270_(owner);
            int floor = (int)distance;
            BlockState chain = this.getChain(entity);
            for (int i = 0; i < floor; ++i) {
                this.dispatcher.m_110912_(chain, poseStack, multiBufferSource, skyLight, OverlayTexture.f_118083_);
                poseStack.m_85837_(0.0, 1.0, 0.0);
            }
            float delta = distance - (float)floor;
            if (((AbstractHookEntity)((Object)entity)).lastDelta - delta > 0.5f || (double)((AbstractHookEntity)((Object)entity)).lastDelta == 0.0) {
                ((AbstractHookEntity)((Object)entity)).lastDelta = delta;
            }
            delta = Mth.m_14179_((float)partialTick, (float)((AbstractHookEntity)((Object)entity)).lastDelta, (float)delta);
            poseStack.m_85841_(1.0f, delta, 1.0f);
            ((AbstractHookEntity)((Object)entity)).lastDelta = delta;
            this.dispatcher.m_110912_(chain, poseStack, multiBufferSource, skyLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
    }

    protected void renderHook(T entity, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int skyLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(entity.m_146908_() - 90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(entity.m_146909_()));
        this.model.m_7695_(poseStack, multiBufferSource.m_6299_(this.model.m_103119_(this.m_5478_((Entity)entity))), skyLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static Vec3 getPosition(Entity entity, double pYOffset, float pPartialTick) {
        double x = Mth.m_14139_((double)pPartialTick, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)pPartialTick, (double)entity.f_19791_, (double)entity.m_20186_()) + pYOffset;
        double z = Mth.m_14139_((double)pPartialTick, (double)entity.f_19792_, (double)entity.m_20189_());
        return new Vec3(x, y, z);
    }
}

