/*
 * Decompiled with CFR 0.152.
 */
package org.hook.mod.entity.hook;

import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.hook.mod.item.hook.AbstractHookItem;
import org.hook.mod.util.CuriosUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHookEntity
extends Projectile {
    private int time = 0;
    public static final EntityDataAccessor<Integer> DATA_HOOK_STATE = SynchedEntityData.m_135353_(AbstractHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final float hookRangeSqr;
    public float lastDelta = 0.0f;

    public AbstractHookEntity(EntityType<? extends AbstractHookEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.hookRangeSqr = 0.0f;
    }

    public AbstractHookEntity(EntityType<? extends AbstractHookEntity> entityType, AbstractHookItem item, Player player, Level level) {
        super(entityType, level);
        this.hookRangeSqr = item.getHookRange() * item.getHookRange();
        this.m_5602_((Entity)player);
        this.m_20242_(true);
        this.m_6034_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_HOOK_STATE, (Object)0);
    }

    public HookState getHookState() {
        return HookState.byId((Integer)this.f_19804_.m_135370_(DATA_HOOK_STATE));
    }

    public void setHookState(HookState state) {
        this.f_19804_.m_135381_(DATA_HOOK_STATE, (Object)state.id);
    }

    protected void onHooked(BlockHitResult hitResult) {
        BlockPos blockPos = hitResult.m_82425_();
        this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockPos)));
        this.m_20256_(Vec3.f_82478_);
        this.setHookState(HookState.HOOKED);
        this.f_19812_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (owner == null || owner.m_213877_()) {
            this.m_146870_();
            return;
        }
        Vec3 motion = this.m_20184_();
        double x = this.m_20185_() + motion.f_82479_;
        double y = this.m_20186_() + motion.f_82480_;
        double z = this.m_20189_() + motion.f_82481_;
        this.m_6034_(x, y, z);
        HookState hookState = this.getHookState();
        ++this.time;
        if (this.time >= 100) {
            this.setHookState(HookState.PULL);
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (hookState == HookState.HOOKED) {
            Vec3 subtract = this.m_20182_().m_82546_(owner.m_20182_());
            if (this.m_20280_(owner) < 20.0) {
                Vec3 motions = subtract.m_82541_().m_82490_(0.06);
                owner.m_20256_(owner.m_20184_().m_82490_(0.85).m_82549_(motions));
            } else {
                Vec3 motions = subtract.m_82541_().m_82490_(0.12);
                owner.m_20256_(owner.m_20184_().m_82490_(0.85).m_82549_(motions));
            }
            if (this.m_20280_(owner) < 10.0 && !owner.m_20096_() || this.m_20280_(owner) > 2000.0) {
                this.setHookState(HookState.PULL);
            }
            return;
        }
        Optional<ItemStack> hook = CuriosUtils.getSlot((LivingEntity)owner, "hook", 0);
        if (hook.isEmpty()) {
            this.m_146870_();
            return;
        }
        if (hookState == HookState.PULL) {
            this.m_146870_();
            return;
        }
        if (this.m_20280_(owner) > (double)this.hookRangeSqr) {
            this.setHookState(HookState.PULL);
            return;
        }
        if (hookState == HookState.PUSH) {
            if (this.m_20280_(owner) < 4.0) {
                this.m_20256_(this.m_20184_().m_82490_(1.3));
            }
            Vec3 pos = this.m_20182_();
            Vec3 nextPos = pos.m_82549_(motion);
            BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(pos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                Vec3 hitPos = hitResult.m_82450_();
                double adjustX = hitPos.f_82479_ - pos.f_82479_;
                double adjustY = hitPos.f_82480_ - pos.f_82480_;
                double adjustZ = hitPos.f_82481_ - pos.f_82481_;
                double newX = pos.f_82479_ + adjustX * 0.8;
                double newY = pos.f_82480_ + adjustY * 0.8;
                double newZ = pos.f_82481_ + adjustZ * 0.8;
                if (hitResult.m_82436_()) {
                    this.m_6034_(this.m_20185_() - adjustX, this.m_20186_() - adjustY, this.m_20189_() - adjustZ);
                } else {
                    this.m_6034_(newX, newY, newZ);
                }
                this.m_8060_(hitResult);
                this.onHooked(hitResult);
            }
        }
    }

    public void m_37251_(@NotNull Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        this.time = 0;
        float x = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, pVelocity, pInaccuracy);
        this.m_20256_(this.m_20184_().m_82490_(15.0));
    }

    public static enum HookState implements StringRepresentable
    {
        PUSH(0, "push"),
        PULL(1, "pull"),
        HOOKED(2, "hooked");

        private static final IntFunction<HookState> BY_ID;
        final int id;
        private final String name;

        private HookState(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static HookState byId(int pId) {
            return BY_ID.apply(pId);
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.m_262839_(HookState::getId, (Object[])HookState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

