/*
 * Decompiled with CFR 0.152.
 */
package org.hook.mod.entity.hook;

import java.util.function.IntFunction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.hook.mod.entity.ModEntities;
import org.hook.mod.entity.hook.AbstractHookEntity;
import org.hook.mod.item.hook.AbstractHookItem;
import org.jetbrains.annotations.NotNull;

public class BaseHookEntity
extends AbstractHookEntity
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(BaseHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BaseHookEntity(EntityType<BaseHookEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BaseHookEntity(AbstractHookItem item, Player player, Level level, Variant variant) {
        super((EntityType<? extends AbstractHookEntity>)((EntityType)ModEntities.BASE_HOOK.get()), item, player, level);
        this.setVariant(variant);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void setVariant(Variant pVariant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)pVariant.id);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public static enum Variant implements StringRepresentable
    {
        GRAPPLING(0, "grappling"),
        AMETHYST(1, "amethyst"),
        TOPAZ(2, "topaz"),
        SAPPHIRE(3, "sapphire"),
        EMERALD(4, "emerald"),
        RUBY(5, "ruby"),
        AMBER(6, "amber"),
        DIAMOND(7, "diamond");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

