/*
 * Decompiled with CFR 0.152.
 */
package org.hook.mod.item.hook;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.hook.mod.entity.hook.AbstractHookEntity;
import org.hook.mod.item.hook.IHookFastThrow;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class AbstractHookItem
extends Item
implements ICurioItem {
    public AbstractHookItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
    }

    public AbstractHookItem(Rarity rarity) {
        this(new Item.Properties().m_41497_(rarity));
    }

    public abstract int getHookAmount();

    public abstract float getHookRange();

    public abstract AbstractHookEntity getHook(ItemStack var1, AbstractHookItem var2, Player var3, Level var4);

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return "hook".equals(slotContext.identifier());
    }

    public boolean canHook(ServerLevel level, ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        Tag tag2 = nbt.m_128423_("hooks");
        if (tag2 instanceof ListTag) {
            ListTag list = (ListTag)tag2;
            list.removeIf(tag -> AbstractHookItem.getHookEntity(tag, level) == null);
            if (this instanceof IHookFastThrow) {
                return list.size() <= this.getHookAmount();
            }
            if (list.isEmpty()) {
                return true;
            }
            return list.stream().allMatch(tag -> {
                AbstractHookEntity hookEntity = AbstractHookItem.getHookEntity(tag, level);
                return hookEntity == null || hookEntity.getHookState() == AbstractHookEntity.HookState.HOOKED;
            });
        }
        nbt.m_128365_("hooks", (Tag)new ListTag());
        return true;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return this.canEquip(slotContext, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (ItemStack.m_41656_((ItemStack)newStack, (ItemStack)stack)) {
            return;
        }
        Level level = slotContext.entity().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = stack.m_41784_().m_128423_("hooks");
            if (level instanceof ListTag) {
                ListTag list = (ListTag)level;
                AbstractHookItem.removeAll(list, level2);
            }
        }
    }

    public static void removeAll(ListTag list, ServerLevel level) {
        list.removeIf(tag -> {
            AbstractHookEntity hookEntity = AbstractHookItem.getHookEntity(tag, level);
            if (hookEntity != null) {
                hookEntity.m_146870_();
            }
            return true;
        });
    }

    @Nullable
    public static AbstractHookEntity getHookEntity(Tag tag, ServerLevel level) {
        if (tag instanceof CompoundTag) {
            AbstractHookEntity hookEntity;
            CompoundTag compoundTag = (CompoundTag)tag;
            Entity entity = level.m_6815_(compoundTag.m_128451_("id"));
            return entity instanceof AbstractHookEntity ? (hookEntity = (AbstractHookEntity)entity) : null;
        }
        return null;
    }
}

