/*
 * Decompiled with CFR 0.152.
 */
package org.hook.mod.network.c2s;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.hook.mod.entity.hook.AbstractHookEntity;
import org.hook.mod.item.hook.AbstractHookItem;
import org.hook.mod.util.CuriosUtils;

public record HookThrowingPacketC2S(boolean aBoolean, float x, float y) {
    public static int id;

    public static HookThrowingPacketC2S hook(boolean aBoolean, float rotX, float rotY) {
        return new HookThrowingPacketC2S(aBoolean, rotX, rotY);
    }

    public static void encode(HookThrowingPacketC2S packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(packet.aBoolean);
        friendlyByteBuf.writeFloat(packet.x);
        friendlyByteBuf.writeFloat(packet.y);
    }

    public static HookThrowingPacketC2S decode(FriendlyByteBuf friendlyByteBuf) {
        return new HookThrowingPacketC2S(friendlyByteBuf.readBoolean(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat());
    }

    public static void handle(HookThrowingPacketC2S packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            CuriosUtils.getSlot((LivingEntity)player, "hook", 0).ifPresent(itemStack -> {
                AbstractHookItem item;
                Item patt1763$temp = itemStack.m_41720_();
                if (patt1763$temp instanceof AbstractHookItem && (item = (AbstractHookItem)patt1763$temp).canHook(level, (ItemStack)itemStack)) {
                    AbstractHookEntity hook = item.getHook((ItemStack)itemStack, item, (Player)player, (Level)level);
                    CompoundTag tag = new CompoundTag();
                    tag.m_128405_("id", hook.m_19879_());
                    Tag patt2098$temp = itemStack.m_41784_().m_128423_("hooks");
                    if (patt2098$temp instanceof ListTag) {
                        ListTag list = (ListTag)patt2098$temp;
                        AbstractHookItem.removeAll(list, level);
                        list.add((Object)tag);
                    }
                    if (packet.aBoolean) {
                        hook.m_37251_((Entity)player, packet.x, packet.y, 0.0f, 0.1f, 0.5f);
                        level.m_7967_((Entity)hook);
                    } else {
                        Entity entity = level.m_6815_(hook.m_19879_());
                        if (entity instanceof AbstractHookEntity) {
                            AbstractHookEntity hookEntity = (AbstractHookEntity)entity;
                            hookEntity.setHookState(AbstractHookEntity.HookState.PULL);
                        }
                    }
                }
            });
        });
        context.setPacketHandled(true);
    }
}

