/*
 * Decompiled with CFR 0.152.
 */
package org.hook.mod.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public final class CuriosUtils {
    public static boolean noSameCurio(LivingEntity living, Class<?> clazz) {
        return CuriosUtils.noSameCurio(living, itemStack -> clazz.isInstance(itemStack.m_41720_()));
    }

    public static boolean noSameCurio(LivingEntity living, Predicate<ItemStack> predicate) {
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
            IItemHandlerModifiable itemHandlerModifiable = handler.getEquippedCurios();
            for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
                if (!predicate.test(itemHandlerModifiable.getStackInSlot(i))) continue;
                isEmpty.set(false);
            }
        });
        return isEmpty.get();
    }

    public static <C extends Item> boolean noSameCurio(LivingEntity living, C curio) {
        return CuriosUtils.noSameCurio(living, itemStack -> itemStack.m_41720_() == curio);
    }

    public static boolean hasCurio(LivingEntity living, Class<?> clazz) {
        return !CuriosUtils.noSameCurio(living, clazz);
    }

    public static boolean hasCurio(LivingEntity living, Predicate<ItemStack> predicate) {
        return !CuriosUtils.noSameCurio(living, predicate);
    }

    public static <C extends Item> boolean hasCurio(LivingEntity living, C curio) {
        return !CuriosUtils.noSameCurio(living, curio);
    }

    public static <C> Optional<C> findCurio(LivingEntity living, Class<C> clazz) {
        AtomicReference atomic = new AtomicReference(Optional.empty());
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
            List results = handler.findCurios(itemStack -> clazz.isInstance(itemStack.m_41720_()));
            if (results.isEmpty()) {
                return;
            }
            atomic.set(Optional.of(clazz.cast(((SlotResult)results.get(0)).stack().m_41720_())));
        });
        return atomic.get();
    }

    public static <C extends Item> Optional<ItemStack> findCurio(LivingEntity living, C curio) {
        AtomicReference atomic = new AtomicReference(Optional.empty());
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
            List results = handler.findCurios(itemStack -> itemStack.m_41720_() == curio);
            if (results.isEmpty()) {
                return;
            }
            atomic.set(Optional.of(((SlotResult)results.get(0)).stack()));
        });
        return atomic.get();
    }

    public static ArrayList<ItemStack> getCurios(LivingEntity living) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(curiosItemHandler -> {
            IItemHandlerModifiable itemHandlerModifiable = curiosItemHandler.getEquippedCurios();
            for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
                ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
                if (itemStack.m_41619_()) continue;
                items.add(itemStack);
            }
        });
        return items;
    }

    public static <C> ArrayList<C> getCurios(LivingEntity living, Class<C> clazz) {
        ArrayList items = new ArrayList();
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
            IItemHandlerModifiable itemHandlerModifiable = handler.getEquippedCurios();
            for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
                ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
                Item item = itemStack.m_41720_();
                if (!clazz.isInstance(item)) continue;
                items.add(clazz.cast(item));
            }
        });
        return items;
    }

    public static Optional<ItemStack> getSlot(LivingEntity living, String id, int index) {
        AtomicReference atomic = new AtomicReference(Optional.empty());
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
            ItemStack stack;
            IDynamicStackHandler stackHandler;
            Map curios = handler.getCurios();
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
            if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots() && !(stack = stackHandler.getStackInSlot(index)).m_41619_()) {
                atomic.set(Optional.of(stack));
            }
        });
        return atomic.get();
    }
}

