/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scp.network;

import java.util.function.Supplier;
import net.mcreator.scp.Scp3008Mod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Scp3008ModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        Scp3008Mod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        Scp3008Mod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.playerenteredshop = message.data.playerenteredshop;
                    variables.playerenteredoffice = message.data.playerenteredoffice;
                    variables.playerenteredparkinglot = message.data.playerenteredparkinglot;
                    variables.obtainedKEY = message.data.obtainedKEY;
                    variables.obtainedFIRSTKEY = message.data.obtainedFIRSTKEY;
                    variables.enterednowalls = message.data.enterednowalls;
                    variables.playerenteredCLUBS = message.data.playerenteredCLUBS;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean playerenteredshop = false;
        public boolean playerenteredoffice = false;
        public boolean playerenteredparkinglot = false;
        public boolean obtainedKEY = false;
        public boolean obtainedFIRSTKEY = false;
        public boolean enterednowalls = false;
        public boolean playerenteredCLUBS = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Scp3008Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("playerenteredshop", this.playerenteredshop);
            nbt.m_128379_("playerenteredoffice", this.playerenteredoffice);
            nbt.m_128379_("playerenteredparkinglot", this.playerenteredparkinglot);
            nbt.m_128379_("obtainedKEY", this.obtainedKEY);
            nbt.m_128379_("obtainedFIRSTKEY", this.obtainedFIRSTKEY);
            nbt.m_128379_("enterednowalls", this.enterednowalls);
            nbt.m_128379_("playerenteredCLUBS", this.playerenteredCLUBS);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.playerenteredshop = nbt.m_128471_("playerenteredshop");
            this.playerenteredoffice = nbt.m_128471_("playerenteredoffice");
            this.playerenteredparkinglot = nbt.m_128471_("playerenteredparkinglot");
            this.obtainedKEY = nbt.m_128471_("obtainedKEY");
            this.obtainedFIRSTKEY = nbt.m_128471_("obtainedFIRSTKEY");
            this.enterednowalls = nbt.m_128471_("enterednowalls");
            this.playerenteredCLUBS = nbt.m_128471_("playerenteredCLUBS");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("scp3008", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "scp3008_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                Scp3008Mod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "scp3008_worldvars";
        public double SpawnX = 0.0;
        public double SpawnY = 0.0;
        public double SpawnZ = 0.0;
        public boolean spawnedELEVATOR = false;
        public boolean spawnedPOWERBOX = false;
        public boolean spawnedMANHOLE = false;
        public double SpawnofficeX = 0.0;
        public double spawnofficeY = 0.0;
        public double spawnofficeZ = 0.0;
        public double spawnparkinglotX = 0.0;
        public double spawnparkinglotY = 0.0;
        public double spawnparkinglotZ = 0.0;
        public boolean placedfarmacyside = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.SpawnX = nbt.m_128459_("SpawnX");
            this.SpawnY = nbt.m_128459_("SpawnY");
            this.SpawnZ = nbt.m_128459_("SpawnZ");
            this.spawnedELEVATOR = nbt.m_128471_("spawnedELEVATOR");
            this.spawnedPOWERBOX = nbt.m_128471_("spawnedPOWERBOX");
            this.spawnedMANHOLE = nbt.m_128471_("spawnedMANHOLE");
            this.SpawnofficeX = nbt.m_128459_("SpawnofficeX");
            this.spawnofficeY = nbt.m_128459_("spawnofficeY");
            this.spawnofficeZ = nbt.m_128459_("spawnofficeZ");
            this.spawnparkinglotX = nbt.m_128459_("spawnparkinglotX");
            this.spawnparkinglotY = nbt.m_128459_("spawnparkinglotY");
            this.spawnparkinglotZ = nbt.m_128459_("spawnparkinglotZ");
            this.placedfarmacyside = nbt.m_128471_("placedfarmacyside");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("SpawnX", this.SpawnX);
            nbt.m_128347_("SpawnY", this.SpawnY);
            nbt.m_128347_("SpawnZ", this.SpawnZ);
            nbt.m_128379_("spawnedELEVATOR", this.spawnedELEVATOR);
            nbt.m_128379_("spawnedPOWERBOX", this.spawnedPOWERBOX);
            nbt.m_128379_("spawnedMANHOLE", this.spawnedMANHOLE);
            nbt.m_128347_("SpawnofficeX", this.SpawnofficeX);
            nbt.m_128347_("spawnofficeY", this.spawnofficeY);
            nbt.m_128347_("spawnofficeZ", this.spawnofficeZ);
            nbt.m_128347_("spawnparkinglotX", this.spawnparkinglotX);
            nbt.m_128347_("spawnparkinglotY", this.spawnparkinglotY);
            nbt.m_128347_("spawnparkinglotZ", this.spawnparkinglotZ);
            nbt.m_128379_("placedfarmacyside", this.placedfarmacyside);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                Scp3008Mod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.playerenteredshop = original.playerenteredshop;
            clone.playerenteredoffice = original.playerenteredoffice;
            clone.playerenteredparkinglot = original.playerenteredparkinglot;
            clone.enterednowalls = original.enterednowalls;
            clone.playerenteredCLUBS = original.playerenteredCLUBS;
            if (!event.isWasDeath()) {
                clone.obtainedKEY = original.obtainedKEY;
                clone.obtainedFIRSTKEY = original.obtainedFIRSTKEY;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    Scp3008Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    Scp3008Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                Scp3008Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

