/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tfar.shippingbin.client.ModClient;
import tfar.shippingbin.init.ModAttributes;
import tfar.shippingbin.init.ModBlockEntityTypes;
import tfar.shippingbin.init.ModBlocks;
import tfar.shippingbin.init.ModItems;
import tfar.shippingbin.init.ModMenuTypes;
import tfar.shippingbin.init.ModSounds;
import tfar.shippingbin.inventory.CommonHandler;
import tfar.shippingbin.level.ShippingBinInventories;
import tfar.shippingbin.network.PacketHandler;
import tfar.shippingbin.platform.Services;
import tfar.shippingbin.trades.Trade;
import tfar.shippingbin.trades.TradeManager;
import tfar.shippingbin.trades.TradeMatcher;

public class ShippingBin {
    public static final String MOD_ID = "shippingbin";
    public static final String MOD_NAME = "ShippingBin";
    public static final Logger LOG = LoggerFactory.getLogger((String)"ShippingBin");
    public static final String FOLDER = "trades";
    private static TradeManager serverTradeManager;

    public static void init() {
        Services.PLATFORM.registerAll(ModBlocks.class, BuiltInRegistries.f_256975_, Block.class);
        Services.PLATFORM.registerAll(ModBlockEntityTypes.class, BuiltInRegistries.f_257049_, BlockEntityType.class);
        Services.PLATFORM.registerAll(ModMenuTypes.class, BuiltInRegistries.f_256818_, MenuType.class);
        Services.PLATFORM.registerAll(ModItems.class, BuiltInRegistries.f_257033_, Item.class);
        Services.PLATFORM.registerAll(ModAttributes.class, BuiltInRegistries.f_256951_, Attribute.class);
        Services.PLATFORM.registerAll(ModSounds.class, BuiltInRegistries.f_256894_, SoundEvent.class);
        PacketHandler.registerPackets();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void onSleep(Level level, long newTime) {
        long newDay = newTime / 24000L;
        long oldTime = level.m_46468_();
        long oldDay = oldTime / 24000L;
        if (newDay > oldDay) {
            ShippingBin.sellItems(level.m_7654_());
        }
    }

    public static void sellItems(MinecraftServer server) {
        ShippingBinInventories shippingBinInventories = ShippingBinInventories.getOrCreateInstance(server);
        for (Map.Entry<UUID, Pair<CommonHandler, CommonHandler>> entry : shippingBinInventories.getHandlerMap().entrySet()) {
            Pair<CommonHandler, CommonHandler> invs = entry.getValue();
            CommonHandler input = (CommonHandler)invs.getKey();
            CommonHandler output = (CommonHandler)invs.getValue();
            UUID uuid = entry.getKey();
            ServerPlayer player = server.m_6846_().m_11259_(uuid);
            double multiplier = player != null ? player.m_21051_(ModAttributes.SELL_MULTIPLIER).m_22135_() : 1.0;
            TradeMatcher tradeMatcher = new TradeMatcher();
            for (int i = 0; i < input.$getSlotCount(); ++i) {
                ItemStack stack = input.$getStack(i);
                if (stack.m_41619_()) continue;
                tradeMatcher.account(stack.m_41777_());
            }
            HashMap<ResourceLocation, Integer> counts = new HashMap<ResourceLocation, Integer>();
            for (Map.Entry<ResourceLocation, Trade> tradeEntry : serverTradeManager.getTrades().entrySet()) {
                ResourceLocation resourceLocation = tradeEntry.getKey();
                Trade trade = tradeEntry.getValue();
                int countTrades = tradeMatcher.countTrades(trade, false);
                if (countTrades <= 0) continue;
                counts.put(resourceLocation, countTrades);
            }
            tradeMatcher.trySellItems(input, output, counts, serverTradeManager.getTrades(), player, multiplier);
        }
    }

    public static TradeManager getTradeManager() {
        if (serverTradeManager == null) {
            return ModClient.getTradeManager();
        }
        return serverTradeManager;
    }

    public static void setTradeManager(TradeManager tradeManager) {
        serverTradeManager = tradeManager;
    }
}

