/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import tfar.shippingbin.ShippingBin;
import tfar.shippingbin.client.ModClientForge;
import tfar.shippingbin.datagen.ModDatagen;
import tfar.shippingbin.init.ModAttributes;
import tfar.shippingbin.init.ModItems;
import tfar.shippingbin.trades.TradeManager;

@Mod(value="shippingbin")
public class ShippingBinForge {
    public static Map<Registry<?>, List<Pair<ResourceLocation, Supplier<?>>>> registerLater = new HashMap();

    public ShippingBinForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModDatagen::gather);
        bus.addListener(this::register);
        bus.addListener(this::setup);
        bus.addListener(this::addAttributes);
        bus.addListener(this::creativeTab);
        MinecraftForge.EVENT_BUS.addListener(this::reloadListener);
        MinecraftForge.EVENT_BUS.addListener(this::serverTick);
        MinecraftForge.EVENT_BUS.addListener(this::onSleep);
        if (FMLEnvironment.dist.isClient()) {
            ModClientForge.init(bus);
        }
        ShippingBin.init();
    }

    private void creativeTab(BuildCreativeModeTabContentsEvent event) {
        CreativeModeTab tab = event.getTab();
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.m_246326_((ItemLike)ModItems.SHIPPING_BIN);
        }
    }

    private void addAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, ModAttributes.SELL_MULTIPLIER);
        event.add(EntityType.f_20532_, ModAttributes.CROP_SELL_MULTIPLIER);
        event.add(EntityType.f_20532_, ModAttributes.MEAT_SELL_MULTIPLIER);
        event.add(EntityType.f_20532_, ModAttributes.GEM_SELL_MULTIPLIER);
        event.add(EntityType.f_20532_, ModAttributes.WOOD_SELL_MULTIPLIER);
    }

    private void onSleep(SleepFinishedTimeEvent event) {
        long newTime = event.getNewTime();
        Level level = (Level)event.getLevel();
        ShippingBin.onSleep(level, newTime);
    }

    private void serverTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        if (event.phase == TickEvent.Phase.START && server.m_129783_().m_46468_() % 24000L == 18000L) {
            ShippingBin.sellItems(server);
        }
    }

    private void reloadListener(AddReloadListenerEvent event) {
        TradeManager tradeManager = new TradeManager();
        ShippingBin.setTradeManager(tradeManager);
        event.addListener((PreparableReloadListener)tradeManager);
    }

    private void register(RegisterEvent e) {
        for (Map.Entry<Registry<?>, List<Pair<ResourceLocation, Supplier<?>>>> entry : registerLater.entrySet()) {
            Registry<?> registry = entry.getKey();
            List<Pair<ResourceLocation, Supplier<?>>> toRegister = entry.getValue();
            for (Pair<ResourceLocation, Supplier<?>> pair : toRegister) {
                e.register(registry.m_123023_(), (ResourceLocation)pair.getLeft(), (Supplier)pair.getValue());
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        registerLater.clear();
    }
}

