/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.blockentity;

import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import tfar.shippingbin.init.ModBlockEntityTypes;
import tfar.shippingbin.inventory.CommonHandler;
import tfar.shippingbin.level.ShippingBinInventories;
import tfar.shippingbin.menu.ShippingBinMenu;
import tfar.shippingbin.platform.Services;

public class ShippingBinBlockEntity<H extends CommonHandler>
extends BlockEntity
implements MenuProvider {
    protected UUID owner = Util.f_137441_;
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            ShippingBinBlockEntity.this.playSound(state, SoundEvents.f_11725_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            ShippingBinBlockEntity.this.playSound(state, SoundEvents.f_11724_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int previousCount, int newCount) {
        }

        protected boolean m_142718_(Player player) {
            return true;
        }
    };

    public ShippingBinBlockEntity(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2) {
        super($$0, $$1, $$2);
    }

    public ShippingBinBlockEntity(BlockPos $$1, BlockState $$2) {
        super(ModBlockEntityTypes.SHIPPING_BIN, $$1, $$2);
    }

    public static BlockEntityType.BlockEntitySupplier<ShippingBinBlockEntity<?>> shippingBin() {
        return (pPos, pState) -> Services.PLATFORM.blockEntity(ModBlockEntityTypes.SHIPPING_BIN, pPos, pState);
    }

    public Pair<H, H> getServerInventory() {
        if (this.f_58857_.f_46443_) {
            return Pair.of(CommonHandler.create(27), CommonHandler.create(27));
        }
        return ShippingBinInventories.getOrCreateInstance(this.f_58857_.m_7654_()).getInventory(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public void startOpen(Player pPlayer) {
        if (!this.m_58901_() && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.m_58901_() && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.m_58901_()) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_("owner", this.owner);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.owner = tag.m_128342_("owner");
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Shipping Bin");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        Pair<H, H> handlers = this.getServerInventory();
        return new ShippingBinMenu<CommonHandler>(id, inventory, (CommonHandler)handlers.getKey(), (CommonHandler)handlers.getValue());
    }
}

