/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tfar.shippingbin.ShippingBin;
import tfar.shippingbin.blockentity.ShippingBinBlockEntity;
import tfar.shippingbin.inventory.ForgeHandler;
import tfar.shippingbin.level.ShippingBinInventories;

public class ShippingBinBlockEntityForge
extends ShippingBinBlockEntity<ForgeHandler> {
    protected LazyOptional<ShippingBinWrapper> optional = LazyOptional.of(() -> new ShippingBinWrapper());

    public ShippingBinBlockEntityForge(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2) {
        super($$0, $$1, $$2);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.optional.cast() : super.getCapability(cap, side);
    }

    public ShippingBinBlockEntityForge(BlockPos $$1, BlockState $$2) {
        super($$1, $$2);
    }

    public class ShippingBinWrapper
    implements IItemHandler {
        private ForgeHandler input;
        private ForgeHandler output;

        public ShippingBinWrapper() {
            Pair pair = ShippingBinBlockEntityForge.this.getServerInventory();
            this.input = (ForgeHandler)pair.getKey();
            this.output = (ForgeHandler)pair.getValue();
        }

        public int getSlots() {
            return this.input.$getSlotCount() + this.output.$getSlotCount();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot < this.input.$getSlotCount()) {
                return this.input.$getStack(slot);
            }
            if (slot - this.input.$getSlotCount() < slot) {
                return this.output.$getStack(slot - this.input.$getSlotCount());
            }
            this.warnSlot(slot);
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot < this.input.$getSlotCount() && this.isItemValid(slot, stack)) {
                return this.input.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < this.input.$getSlotCount()) {
                return ItemStack.f_41583_;
            }
            if (slot - this.input.$getSlotCount() < this.output.$getSlotCount()) {
                return this.output.extractItem(slot - this.input.$getSlotCount(), amount, simulate);
            }
            this.warnSlot(slot);
            return ItemStack.f_41583_;
        }

        protected void warnSlot(int slot) {
            ShippingBin.LOG.warn("Tried to access out of bounds slot {}", (Object)slot);
            new Throwable().printStackTrace();
        }

        public int getSlotLimit(int slot) {
            if (slot < this.input.$getSlotCount()) {
                return this.input.getSlotLimit(slot);
            }
            if (slot - this.input.$getSlotCount() < this.output.$getSlotCount()) {
                return this.output.getSlotLimit(slot - this.input.$getSlotCount());
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ShippingBinInventories.ONLY_INPUTS.test(stack);
        }
    }
}

