/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.slf4j.Logger;
import tfar.shippingbin.trades.Trade;

public class TradeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<ResourceLocation, Trade> trades;
    Set<Ingredient> allowedInputs = new HashSet<Ingredient>();
    private boolean hasErrors;

    public TradeManager() {
        super(GSON, "trades");
        this.trades = ImmutableMap.of();
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.hasErrors = false;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> resourceLocationJsonElementEntry : map.entrySet()) {
            ResourceLocation location = resourceLocationJsonElementEntry.getKey();
            try {
                Trade trade = TradeManager.fromJson(location, GsonHelper.m_13918_((JsonElement)resourceLocationJsonElementEntry.getValue(), (String)"top element"));
                if (trade == null) continue;
                builder.put((Object)location, (Object)trade);
                this.allowedInputs.add(trade.input());
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error("Parsing error loading trade {}", (Object)location, (Object)exception);
            }
        }
        this.trades = builder.build();
        LOGGER.info("Loaded {} trades", (Object)this.trades.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public Map<ResourceLocation, Trade> getTrades() {
        return this.trades;
    }

    public boolean isInput(ItemStack stack) {
        return this.allowedInputs.stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    public static Trade fromJson(ResourceLocation id, JsonObject jsonObject) {
        return Trade.deserialize(jsonObject);
    }
}

