/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.client;

import java.util.HashMap;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.zeus.sp.client.screen.SelectCameraScreen;
import net.zeus.sp.event.ClientHandler;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import net.zeus.sp.level.entity.entities.CameraEntity;
import net.zeus.sp.level.sounds.SPSounds;

public class ClientData {
    public static CameraEntity currentCameraEntity;
    public static CameraBlockEntity currentCamera;
    public static float accumulatedYRot;
    public static float accumulatedXRot;
    public static float yRot;
    public static float xRot;
    public static float baseYRot;
    public static boolean controller;
    public static HashMap<Integer, Boolean> existingCameras;
    public static HashMap<Integer, CameraData> cameraData;

    public static Entity getEntity(int id) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level == null ? null : level.m_6815_(id);
    }

    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void handleCameraChange(int id, BlockPos pos, float accumulatedYRot, float accumulatedXRot, float yRot, float xRot, boolean controller) {
        CameraBlockEntity cameraBlockEntity;
        currentCameraEntity = null;
        currentCamera = null;
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Entity entity = ClientData.getEntity(id);
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (entity instanceof CameraEntity && blockEntity instanceof CameraBlockEntity) {
            Minecraft.m_91087_().f_91063_.m_172736_(false);
            Minecraft.m_91087_().m_91118_(entity);
            ((CameraEntity)entity).f_20885_ = yRot;
            entity.m_146926_(xRot);
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
        } else {
            Minecraft.m_91087_().f_91063_.m_172736_(true);
            Minecraft.m_91087_().m_91118_((Entity)ClientData.getPlayer());
        }
        ClientData.getPlayer().m_216990_((SoundEvent)SPSounds.BLIP.get());
        currentCameraEntity = entity instanceof CameraEntity && blockEntity instanceof CameraBlockEntity ? (CameraEntity)entity : null;
        currentCamera = blockEntity instanceof CameraBlockEntity ? (cameraBlockEntity = (CameraBlockEntity)blockEntity) : null;
        baseYRot = yRot - accumulatedYRot;
        ClientData.accumulatedYRot = accumulatedYRot;
        ClientData.accumulatedXRot = accumulatedXRot;
        ClientData.xRot = xRot;
        ClientData.yRot = yRot;
        ClientData.controller = controller;
        if (currentCamera != null && ClientData.currentCamera.modules.contains((Object)CameraBlockEntity.Module.LENS)) {
            Minecraft.m_91087_().f_91063_.m_109128_(ResourceLocation.m_214293_((String)"sp", (String)"shaders/grayscale.json"));
        }
    }

    public static void handleCameraInfo(int id, BlockPos pos, Component customName, boolean lastCamera, float yRot) {
        CameraBlockEntity cameraBlockEntity;
        BlockEntity blockEntity = ClientData.getPlayer().m_9236_().m_7702_(pos);
        CameraBlockEntity entity = blockEntity instanceof CameraBlockEntity ? (cameraBlockEntity = (CameraBlockEntity)blockEntity) : null;
        cameraData.put(id, new CameraData(id, entity, (Component)(customName.equals(Component.m_237119_()) ? Component.m_237113_((String)"CAM %s%d".formatted(id + 1 < 10 ? "0" : "", id + 1)) : customName), yRot));
        existingCameras.computeIfPresent(id, (integer, aBoolean) -> true);
        if (entity != null) {
            entity.yRot = yRot;
        }
        if ((blockEntity = Minecraft.m_91087_().f_91080_) instanceof SelectCameraScreen) {
            SelectCameraScreen screen = (SelectCameraScreen)blockEntity;
            screen.updateCamera(id, customName, lastCamera);
        }
    }

    public static void clear() {
        currentCameraEntity = null;
        currentCamera = null;
        accumulatedYRot = 0.0f;
        accumulatedXRot = 0.0f;
        yRot = 0.0f;
        xRot = 0.0f;
        baseYRot = 0.0f;
        controller = false;
        existingCameras.clear();
        cameraData.clear();
        ClientHandler.crawlingCooldown = 0;
        ClientHandler.crawling = 2;
    }

    static {
        accumulatedYRot = 0.0f;
        accumulatedXRot = 0.0f;
        yRot = 0.0f;
        xRot = 0.0f;
        baseYRot = 0.0f;
        controller = false;
        existingCameras = new HashMap();
        cameraData = new HashMap();
    }

    public record CameraData(int id, CameraBlockEntity entity, Component customName, float yRot) {
    }
}

