/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.client.screen;

import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.zeus.sp.client.screen.widgets.SPCheckbox;
import net.zeus.sp.client.screen.widgets.SPSlider;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import net.zeus.sp.networking.C2S.EditCameraPacket;
import net.zeus.sp.networking.SPMessages;

public class EditCameraScreen
extends Screen {
    private final ResourceLocation BACKGROUND = new ResourceLocation("sp", "screen/edit/background.png");
    private final ResourceLocation HIDE = new ResourceLocation("sp", "screen/edit/hide.png");
    private final HashMap<CameraBlockEntity.Module, SPCheckbox> moduleToggles = new HashMap();
    private final CameraBlockEntity entity;
    private SPCheckbox disableToggle;
    private SPCheckbox panningToggle;
    private EditBox nameField;

    public EditCameraScreen(CameraBlockEntity entity) {
        super((Component)Component.m_237113_((String)"Edit Camera"));
        this.entity = entity;
    }

    protected void m_7856_() {
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int xSize = 211;
        int ySize = 156;
        this.disableToggle = new SPCheckbox(x - xSize / 2 + 55, y - ySize / 2 + 129, 20, 20, (Component)Component.m_237119_(), this.entity.hidden, a -> {
            this.toggleDisable();
            a.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"%s Camera Feed".formatted(!this.entity.hidden ? "Show" : "Hide"))));
        });
        this.disableToggle.setCheckmark(new ResourceLocation("sp", "screen/checkbox/display.png"));
        this.disableToggle.setCheckmarkDisabled(new ResourceLocation("sp", "screen/checkbox/display_disabled.png"));
        this.disableToggle.setCheckmarkSize(16, 16);
        this.disableToggle.shouldRender(() -> !this.entity.hidden);
        this.disableToggle.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"%s Camera Feed".formatted(this.entity.hidden ? "Show" : "Hide"))));
        this.panningToggle = new SPCheckbox(x - xSize / 2 + 137, y - ySize / 2 + 129, 20, 20, (Component)Component.m_237119_(), this.entity.panning, a -> {
            this.togglePanning();
            a.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"%s Panning".formatted(!this.entity.panning ? "Disable" : "Enable"))));
        });
        this.panningToggle.shouldRender(() -> this.entity.panning);
        this.panningToggle.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"%s Panning".formatted(this.entity.panning ? "Disable" : "Enable"))));
        this.nameField = new EditBox(this.f_96547_, x - xSize / 2 + 24, y - ySize / 2 + 10, 165, 18, this.entity.customName);
        this.nameField.m_94182_(false);
        this.nameField.m_94151_(a -> this.updateName((Component)Component.m_237113_((String)a)));
        this.nameField.m_94144_(this.entity.customName == null ? "" : this.entity.customName.getString());
        SPSlider slider = new SPSlider(x - xSize / 2, y + ySize / 2 + 10, xSize, 20, (Component)Component.m_237113_((String)"Pan Speed"), (Component)Component.m_237119_(), 0.0, 1.0, this.entity.panSpeed, true, () -> this.entity.panning, speed -> this.updatePanSpeed((float)speed.doubleValue()));
        SPCheckbox flashlightButton = new SPCheckbox(x - xSize / 2 + 8, y - ySize / 2 + 129, 20, 20, (Component)Component.m_237119_(), this.entity.modules.contains((Object)CameraBlockEntity.Module.FLASHLIGHT), a -> this.removeModule(CameraBlockEntity.Module.FLASHLIGHT));
        SPCheckbox nightVisionButton = new SPCheckbox(x - xSize / 2 + 32, y - ySize / 2 + 129, 20, 20, (Component)Component.m_237119_(), this.entity.modules.contains((Object)CameraBlockEntity.Module.NIGHTVISION), a -> this.removeModule(CameraBlockEntity.Module.NIGHTVISION));
        SPCheckbox motionButton = new SPCheckbox(x - xSize / 2 + 103, y - ySize / 2 + 129, 20, 20, (Component)Component.m_237119_(), this.entity.modules.contains((Object)CameraBlockEntity.Module.MOTION), a -> this.removeModule(CameraBlockEntity.Module.MOTION));
        SPCheckbox lensButton = new SPCheckbox(x - xSize / 2 + 80, y - ySize / 2 + 129, 20, 20, (Component)Component.m_237119_(), this.entity.modules.contains((Object)CameraBlockEntity.Module.LENS), a -> this.removeModule(CameraBlockEntity.Module.LENS));
        SPCheckbox redstoneButton = new SPCheckbox(x - xSize / 2 + 162, y - ySize / 2 + 129, 20, 20, (Component)Component.m_237119_(), this.entity.modules.contains((Object)CameraBlockEntity.Module.REDSTONE), a -> this.removeModule(CameraBlockEntity.Module.REDSTONE));
        flashlightButton.setCheckmark(new ResourceLocation("sp", "textures/item/flashlight_module.png"));
        nightVisionButton.setCheckmark(new ResourceLocation("sp", "textures/item/nightvision_module.png"));
        motionButton.setCheckmark(new ResourceLocation("sp", "textures/item/motion_detector_module.png"));
        lensButton.setCheckmark(new ResourceLocation("sp", "textures/item/lens_module.png"));
        redstoneButton.setCheckmark(new ResourceLocation("sp", "textures/item/redstone_module.png"));
        flashlightButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Flashlight")));
        nightVisionButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Night Vision")));
        motionButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Motion Detector")));
        lensButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Lens")));
        redstoneButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Redstone")));
        flashlightButton.shouldRender(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.FLASHLIGHT));
        nightVisionButton.shouldRender(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.NIGHTVISION));
        motionButton.shouldRender(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.MOTION));
        lensButton.shouldRender(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.LENS));
        redstoneButton.shouldRender(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.REDSTONE));
        flashlightButton.setCanPress(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.FLASHLIGHT));
        flashlightButton.setCheckmarkSize(16, 16);
        nightVisionButton.setCanPress(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.NIGHTVISION));
        nightVisionButton.setCheckmarkSize(16, 16);
        motionButton.setCanPress(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.MOTION));
        motionButton.setCheckmarkSize(16, 16);
        lensButton.setCanPress(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.LENS));
        lensButton.setCheckmarkSize(16, 16);
        redstoneButton.setCanPress(() -> this.entity.modules.contains((Object)CameraBlockEntity.Module.REDSTONE));
        redstoneButton.setCheckmarkSize(16, 16);
        this.m_142416_((GuiEventListener)nightVisionButton);
        this.m_142416_((GuiEventListener)flashlightButton);
        this.m_142416_((GuiEventListener)redstoneButton);
        this.m_142416_((GuiEventListener)this.panningToggle);
        this.m_142416_((GuiEventListener)this.disableToggle);
        this.m_142416_((GuiEventListener)motionButton);
        this.m_142416_((GuiEventListener)lensButton);
        this.m_142416_((GuiEventListener)this.nameField);
        this.m_142416_((GuiEventListener)slider);
        this.moduleToggles.put(CameraBlockEntity.Module.FLASHLIGHT, flashlightButton);
        this.moduleToggles.put(CameraBlockEntity.Module.NIGHTVISION, nightVisionButton);
        this.moduleToggles.put(CameraBlockEntity.Module.MOTION, motionButton);
        this.moduleToggles.put(CameraBlockEntity.Module.LENS, lensButton);
        this.moduleToggles.put(CameraBlockEntity.Module.REDSTONE, redstoneButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int xSize = 211;
        int ySize = 156;
        guiGraphics.m_280163_(this.BACKGROUND, this.f_96543_ / 2 - xSize / 2, this.f_96544_ / 2 - ySize / 2, 0.0f, 0.0f, xSize, ySize, xSize, ySize);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void updateName(Component newName) {
        this.update(newName, false, false, null, -1.0f);
    }

    public void toggleDisable() {
        this.update((Component)Component.m_237113_((String)"no-update-dev-tag"), true, false, null, -1.0f);
    }

    public void togglePanning() {
        this.update((Component)Component.m_237113_((String)"no-update-dev-tag"), false, true, null, -1.0f);
    }

    public void removeModule(CameraBlockEntity.Module removedModule) {
        this.update((Component)Component.m_237113_((String)"no-update-dev-tag"), false, false, removedModule, -1.0f);
    }

    public void updatePanSpeed(float panSpeed) {
        this.update((Component)Component.m_237113_((String)"no-update-dev-tag"), false, false, null, panSpeed);
    }

    private void update(Component newName, boolean disableToggle, boolean panningToggle, CameraBlockEntity.Module removedModule, float panSpeed) {
        SPMessages.sendToServer(new EditCameraPacket(newName, disableToggle, panningToggle, removedModule, panSpeed));
    }

    public boolean m_7043_() {
        return false;
    }
}

