/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.level.block.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.zeus.sp.data.PlayerData;
import net.zeus.sp.level.block.SPBlockEntities;
import net.zeus.sp.level.block.blocks.CameraBlock;
import net.zeus.sp.level.entity.entities.CameraEntity;
import net.zeus.sp.level.item.SPItems;
import net.zeus.sp.level.item.items.ModuleItem;
import net.zeus.sp.level.item.items.Tablet;
import net.zeus.sp.networking.S2C.SendCameraInfoPacket;
import net.zeus.sp.networking.S2C.SetCameraPacket;
import net.zeus.sp.networking.SPMessages;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CameraBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final Set<String> WRENCHES = new HashSet<String>();
    private CameraEntity cameraEntity;
    private int cameraID = -1;
    public float accumulatedYRot = 0.0f;
    public float accumulatedXRot = 0.0f;
    public float yRot = 0.0f;
    public float xRot = 0.0f;
    public float baseYRot = 0.0f;
    public boolean locked = false;
    public float lockedYRot = 0.0f;
    public float lockedXRot = 0.0f;
    public float zoom = 0.0f;
    public float lockedZoom = 0.0f;
    public Component customName = null;
    public boolean moveable = true;
    protected ServerPlayer controller = null;
    public Set<Module> modules = new HashSet<Module>();
    protected boolean motionDetected = false;
    private int motionDetectedTicks = 0;
    public boolean redstone = false;
    public int redstoneTicks = 0;
    public boolean panning = false;
    protected boolean panLeft = false;
    public boolean hidden = false;
    public float panSpeed = 1.0f;
    public int panFreezeTicks = 0;

    public CameraBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SPBlockEntities.CAMERA_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void tick(Level level) {
        if (level.f_46443_) {
            return;
        }
        int scanRadius = 16;
        AABB box = new AABB(this.f_58858_.m_7918_(-scanRadius, -scanRadius, -scanRadius), this.f_58858_.m_7918_(scanRadius, scanRadius, scanRadius));
        for (Entity entity : level.m_45933_(null, box)) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !this.isEntityMoving(living = (LivingEntity)entity) || this.motionDetected || !this.hasLineOfSight(entity) || !this.isInAngle(this.f_58858_.m_252807_(), entity.m_20182_(), this.xRot, this.yRot, 90.0f - this.zoom)) continue;
            this.motionDetected = true;
            this.motionDetectedTicks = 35;
            break;
        }
        if (this.motionDetectedTicks > 0) {
            --this.motionDetectedTicks;
            level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        } else {
            this.motionDetected = false;
        }
        if (this.panFreezeTicks > 0) {
            --this.panFreezeTicks;
        }
        if (this.panning && this.panFreezeTicks <= 0) {
            boolean pan0 = this.panLeft;
            boolean bl = this.panLeft = (this.accumulatedYRot >= 45.0f || this.accumulatedYRot <= -45.0f) != this.panLeft;
            if (pan0 != this.panLeft) {
                this.panFreezeTicks = 30;
            }
            this.rotateCamera(this.f_58857_, Mth.m_14036_((float)this.panSpeed, (float)0.0f, (float)1.0f) * (float)(this.panLeft ? 1 : -1), 0.0f, 0.0f);
        }
        if (this.redstoneTicks > 0) {
            --this.redstoneTicks;
        } else if (this.redstone) {
            this.redstone = false;
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            this.updateRedstone();
        }
    }

    public void accessCamera(ServerPlayer player) {
        if (this.controller == null && this.cameraEntity != null) {
            this.cameraEntity.m_146870_();
        }
        if (this.cameraEntity == null || this.cameraEntity.m_213877_()) {
            this.cameraEntity = this.getOrCreateCamera(player.m_9236_());
        }
        if (this.controller == null) {
            if (this.locked) {
                this.accumulatedYRot = this.lockedYRot;
                this.accumulatedXRot = this.lockedXRot;
                this.zoom = this.lockedZoom;
            }
            this.calculateYRot(0.0f);
            this.calculateXRot(0.0f);
        }
        PlayerData.get((Player)player).currentCamera = this;
        this.cameraEntity.f_20885_ = this.yRot;
        this.cameraEntity.m_146926_(this.xRot);
        SPMessages.sendToPlayer(new SetCameraPacket(this.cameraID, this.f_58858_, this.accumulatedYRot, this.accumulatedXRot, this.yRot, this.xRot, this.controller == null), (Player)player);
        if (this.controller == null) {
            this.controller = player;
        }
    }

    public void update(Component newName, boolean disableToggle, boolean panningToggle, Module removedModule, float panSpeed) {
        if (newName != null && !newName.getString().equals("no-update-dev-tag")) {
            Component component = this.customName = newName.equals(Component.m_237119_()) ? null : newName;
        }
        if (disableToggle) {
            boolean bl = this.hidden = !this.hidden;
        }
        if (panningToggle) {
            boolean bl = this.panning = !this.panning;
        }
        if (removedModule != Module.NONE && this.modules.contains((Object)removedModule) && this.f_58857_ != null) {
            ItemStack moduleStack = removedModule.getItem().m_7968_();
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), moduleStack));
            this.modules.remove((Object)removedModule);
        }
        if (panSpeed != -1.0f) {
            this.panSpeed = Mth.m_14036_((float)panSpeed, (float)0.0f, (float)1.0f);
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void updateRedstone() {
        if (this.m_58904_() != null) {
            this.m_58904_().m_46672_(this.getWorldPosition(), this.m_58900_().m_60734_());
            Direction.m_235666_().forEach(direction -> this.m_58904_().m_46672_(this.getWorldPosition().m_121945_(direction), this.m_58900_().m_60734_()));
        }
    }

    public boolean motionDetected() {
        return this.motionDetected && this.motionDetectedTicks > 0;
    }

    public void disconnect(ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        PlayerData.get((Player)serverPlayer).currentCamera = null;
        SPMessages.sendToPlayer(new SetCameraPacket(-1, BlockPos.f_121853_, 0.0f, 0.0f, 0.0f, 0.0f, false), (Player)serverPlayer);
        if (serverPlayer.equals((Object)this.controller)) {
            this.controller = null;
        }
    }

    public ServerPlayer getController() {
        return this.controller;
    }

    public void updateCamera(ServerPlayer player, float yRot, float xRot, float zoom, boolean dismounted) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (this.cameraEntity == null) {
            this.cameraEntity = this.getOrCreateCamera(player.m_9236_());
        }
        if (dismounted) {
            this.disconnect(player);
            return;
        }
        if ((this.controller == null || this.controller.m_21224_() || this.controller.m_213877_()) && yRot != -361.0f) {
            this.accessCamera(player);
        }
        if (this.moveable && player.equals((Object)this.controller) && !this.panning) {
            this.rotateCamera(player.m_9236_(), yRot, xRot, zoom);
        }
        player.m_9236_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void rotateCamera(Level level, float yRot, float xRot, float zoom) {
        if (this.moveable) {
            this.calculateYRot(yRot);
            this.calculateXRot(xRot);
            this.zoom = Mth.m_14036_((float)(this.zoom + zoom), (float)0.0f, (float)45.0f);
            level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void loadModule(Level level, ItemStack stack) {
        if (stack.m_41720_().equals(SPItems.TABLET.get())) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof ModuleItem) {
            ModuleItem item2 = (ModuleItem)item;
            if (!this.modules.contains((Object)item2.module) && this.modules.stream().noneMatch(module -> module.getItem().conflictsWith(item.module))) {
                item2.onLoad(this, stack);
                this.modules.add(item2.module);
                stack.m_41774_(1);
                this.m_6596_();
            }
        }
        this.m_6596_();
        level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void handleModule(Module module) {
        if (this.modules.contains((Object)module)) {
            module.getItem().onUse(this);
        }
    }

    public void switchLock() {
        boolean bl = this.locked = !this.locked;
        if (this.locked) {
            this.lockedYRot = this.accumulatedYRot;
            this.lockedXRot = this.accumulatedXRot;
            this.lockedZoom = this.zoom;
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void calculateYRot(float add) {
        this.accumulatedYRot = Mth.m_14036_((float)(this.accumulatedYRot - add), (float)-90.0f, (float)90.0f);
        this.yRot = Mth.m_14036_((float)(this.baseYRot + this.accumulatedYRot), (float)(this.baseYRot - 90.0f), (float)(this.baseYRot + 90.0f));
        this.m_6596_();
    }

    public void calculateXRot(float add) {
        this.xRot = this.accumulatedXRot = Mth.m_14036_((float)(this.accumulatedXRot - add), (float)0.0f, (float)65.0f);
        this.m_6596_();
    }

    public void sendCameraInfo(ServerPlayer serverPlayer, ItemStack stack, int id) {
        if (stack.m_41720_().equals(SPItems.TABLET.get())) {
            int count = Tablet.cameraCount(stack);
            SPMessages.sendToPlayer(new SendCameraInfoPacket(id, this.f_58858_, (Component)(this.customName == null ? Component.m_237119_() : this.customName), count == id + 1, this.yRot), (Player)serverPlayer);
            this.updateCamera(serverPlayer, -361.0f, 0.0f, 0.0f, false);
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        Vec3 vec3 = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        Vec3 vec31 = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return entity.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    private boolean isInAngle(Vec3 from, Vec3 to, float xRot, float yRot, double angle) {
        Vec3 dirVec = new Vec3(to.f_82479_ - from.f_82479_, to.f_82480_ - from.f_82480_, to.f_82481_ - from.f_82481_).m_82541_();
        double dot = dirVec.m_82526_(this.calculateViewVector(xRot, yRot).m_82541_());
        return dot >= Mth.m_14139_((double)(angle / 360.0), (double)1.0, (double)-1.0);
    }

    private Vec3 calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    private boolean isEntityMoving(LivingEntity livingEntity) {
        return livingEntity.f_19787_ - livingEntity.f_19867_ > 0.0f;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("cameraID", this.cameraID);
        pTag.m_128350_("accumulatedYRot", this.accumulatedYRot);
        pTag.m_128350_("accumulatedXRot", this.accumulatedXRot);
        pTag.m_128350_("yRot", this.yRot);
        pTag.m_128350_("xRot", this.xRot);
        pTag.m_128350_("baseYRot", this.baseYRot);
        pTag.m_128350_("lockedYRot", this.lockedYRot);
        pTag.m_128350_("lockedXRot", this.lockedXRot);
        pTag.m_128350_("zoom", this.zoom);
        pTag.m_128350_("lockedZoom", this.lockedZoom);
        pTag.m_128379_("locked", this.locked);
        pTag.m_128359_("customName", Component.Serializer.m_130703_((Component)this.customName));
        pTag.m_128379_("moveable", this.moveable);
        pTag.m_128379_("motionDetected", this.motionDetected);
        pTag.m_128405_("motionDetectedTicks", this.motionDetectedTicks);
        pTag.m_128379_("redstone", this.redstone);
        ListTag listTag = new ListTag();
        for (Module module : this.modules) {
            CompoundTag moduleTag = new CompoundTag();
            moduleTag.m_128405_("module", module.ordinal());
            listTag.add((Object)moduleTag);
        }
        pTag.m_128365_("modules", (Tag)listTag);
        pTag.m_128379_("panning", this.panning);
        pTag.m_128379_("hidden", this.hidden);
        pTag.m_128350_("panSpeed", this.panSpeed);
    }

    public void deserialize(CompoundTag nbt) {
        this.cameraID = nbt.m_128451_("cameraID");
        this.accumulatedYRot = nbt.m_128457_("accumulatedYRot");
        this.accumulatedXRot = nbt.m_128457_("accumulatedXRot");
        this.yRot = nbt.m_128457_("yRot");
        this.xRot = nbt.m_128457_("xRot");
        this.baseYRot = nbt.m_128457_("baseYRot");
        this.lockedYRot = nbt.m_128457_("lockedYRot");
        this.lockedXRot = nbt.m_128457_("lockedXRot");
        this.zoom = nbt.m_128457_("zoom");
        this.lockedZoom = nbt.m_128457_("lockedZoom");
        this.locked = nbt.m_128471_("locked");
        this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("customName"));
        this.moveable = nbt.m_128471_("moveable");
        this.motionDetected = nbt.m_128471_("motionDetected");
        this.motionDetectedTicks = nbt.m_128451_("motionDetectedTicks");
        this.redstone = nbt.m_128471_("redstone");
        ListTag listTag = nbt.m_128437_("modules", 10);
        this.modules.clear();
        for (Tag tag : listTag) {
            CompoundTag moduleTag = (CompoundTag)tag;
            this.modules.add(Module.values()[moduleTag.m_128451_("module")]);
        }
        this.panning = nbt.m_128471_("panning");
        this.hidden = nbt.m_128471_("hidden");
        this.panSpeed = nbt.m_128457_("panSpeed");
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.deserialize(pTag);
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.deserialize(nbt);
    }

    private CameraEntity getOrCreateCamera(Level level) {
        CameraEntity camEntity;
        CameraEntity entity;
        Entity entity2 = level.m_6815_(this.cameraID);
        CameraEntity cameraEntity = entity = entity2 instanceof CameraEntity ? (camEntity = (CameraEntity)entity2) : null;
        if (entity == null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)CameraBlock.f_54117_);
            entity = new CameraEntity((Level)serverLevel, this.f_58858_);
            this.yRot = this.baseYRot = direction.m_122435_();
            entity.m_146922_(this.baseYRot);
            entity.m_264318_(serverLevel, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.65f, (float)this.f_58858_.m_123343_() + 0.5f, Set.of(), this.yRot, 0.0f);
            entity.m_6842_(true);
            entity.m_20242_(true);
            entity.f_19794_ = true;
            entity.m_20331_(true);
            this.cameraID = entity.m_19879_();
            level.m_7967_((Entity)entity);
        }
        return entity;
    }

    public void m_7651_() {
        if (this.cameraEntity != null) {
            this.cameraEntity.m_146870_();
        }
        super.m_7651_();
    }

    public void onChunkUnloaded() {
        if (this.cameraEntity != null) {
            this.cameraEntity.m_146870_();
        }
        super.onChunkUnloaded();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean isWrench(Item item) {
        String[] idSplit = item.m_5524_().split("[.]");
        String id = "%s:%s".formatted(idSplit[idSplit.length - 2], idSplit[idSplit.length - 1]);
        return WRENCHES.contains(id);
    }

    public BlockPos getWorldPosition() {
        return this.f_58858_;
    }

    public static void init() {
        WRENCHES.add("minecraft:stick");
        WRENCHES.add("management_wanted:fazwrench");
    }

    public static enum Module {
        NONE((Supplier<Item>)ItemStack.f_41583_.m_220173_()),
        FLASHLIGHT((Supplier<Item>)SPItems.FLASHLIGHT_MODULE),
        NIGHTVISION((Supplier<Item>)SPItems.NIGHTVISION_MODULE),
        REDSTONE((Supplier<Item>)SPItems.REDSTONE_MODULE),
        MOTION((Supplier<Item>)SPItems.MOTION_MODULE),
        LENS((Supplier<Item>)SPItems.LENS_MODULE);

        public final Supplier<Item> item;

        private Module(Supplier<Item> item) {
            this.item = item;
        }

        public ModuleItem getItem() {
            return (ModuleItem)this.item.get();
        }
    }
}

