/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.level.item.items;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.zeus.sp.level.block.entities.CameraBlockEntity;

public class ModuleItem
extends Item {
    public final CameraBlockEntity.Module module;
    private final ResourceLocation frame;
    private final ResourceLocation on;
    private final ResourceLocation off;
    private boolean hasFrame = true;
    private ResourceLocation shader = null;
    private ResourceLocation shader_grayscale = null;
    private Supplier<SoundEvent> sound = () -> null;
    private Consumer<CameraBlockEntity> onUse = entity -> {};
    private Set<CameraBlockEntity.Module> conflicts = new HashSet<CameraBlockEntity.Module>();
    public boolean enabled = false;

    public ModuleItem(CameraBlockEntity.Module module) {
        super(new Item.Properties());
        this.module = module;
        this.frame = new ResourceLocation("sp", "screen/selection/module/%s_frame.png".formatted(module.name().toLowerCase()));
        this.on = new ResourceLocation("sp", "screen/selection/module/%s_highlighted.png".formatted(module.name().toLowerCase()));
        this.off = new ResourceLocation("sp", "screen/selection/module/%s.png".formatted(module.name().toLowerCase()));
    }

    public ModuleItem setHasFrame(boolean hasFrame) {
        this.hasFrame = hasFrame;
        return this;
    }

    public ModuleItem setShader(String shader, boolean hasGrayscale) {
        this.shader = new ResourceLocation("sp", "shaders/post/%s.json".formatted(shader));
        if (hasGrayscale) {
            this.shader_grayscale = new ResourceLocation("sp", "shaders/post/%s_gray.json".formatted(shader));
        }
        return this;
    }

    public ModuleItem setSound(Supplier<SoundEvent> sound) {
        this.sound = sound;
        return this;
    }

    public ModuleItem setOnUse(Consumer<CameraBlockEntity> onUse) {
        this.onUse = onUse;
        return this;
    }

    public ModuleItem addConflict(CameraBlockEntity.Module id) {
        this.conflicts.add(id);
        return this;
    }

    public boolean hasFrame() {
        return this.hasFrame;
    }

    public ResourceLocation getFrame() {
        return this.frame;
    }

    public ResourceLocation getOn() {
        return this.on;
    }

    public ResourceLocation getOff() {
        return this.off;
    }

    public ResourceLocation getShader(boolean gray) {
        return gray ? this.shader_grayscale : this.shader;
    }

    public SoundEvent getSound() {
        return this.sound.get();
    }

    public void onUse(CameraBlockEntity entity) {
        this.onUse.accept(entity);
    }

    public boolean conflictsWith(CameraBlockEntity.Module id) {
        return this.conflicts.contains((Object)id);
    }

    public void onLoad(CameraBlockEntity entity, ItemStack stack) {
    }
}

