/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking.C2S;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.zeus.sp.data.PlayerData;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import net.zeus.sp.networking.Packet;

public class EditCameraPacket
extends Packet {
    private final Component newTitle;
    private final boolean disabled;
    private final boolean panning;
    private final CameraBlockEntity.Module removedModule;
    private final float panSpeed;

    public EditCameraPacket(Component newTitle, boolean disabled, boolean panning, CameraBlockEntity.Module removedModule, float panSpeed) {
        this.newTitle = newTitle;
        this.disabled = disabled;
        this.panning = panning;
        this.removedModule = removedModule;
        this.panSpeed = panSpeed;
    }

    public EditCameraPacket(FriendlyByteBuf byteBuf) {
        this.newTitle = byteBuf.m_130238_();
        this.disabled = byteBuf.readBoolean();
        this.panning = byteBuf.readBoolean();
        this.removedModule = CameraBlockEntity.Module.values()[byteBuf.readInt()];
        this.panSpeed = byteBuf.readFloat();
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.m_130083_((Component)(this.newTitle == null ? Component.m_237119_() : this.newTitle));
        byteBuf.writeBoolean(this.disabled);
        byteBuf.writeBoolean(this.panning);
        byteBuf.writeInt(this.removedModule == null ? 0 : this.removedModule.ordinal());
        byteBuf.writeFloat(this.panSpeed);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || PlayerData.get((Player)player).currentEditingCamera == null) {
                return;
            }
            PlayerData.get((Player)player).currentEditingCamera.update(this.newTitle, this.disabled, this.panning, this.removedModule, this.panSpeed);
        });
        context.setPacketHandled(true);
    }
}

