/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking.C2S;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.zeus.sp.data.PlayerData;
import net.zeus.sp.networking.Packet;

public class PosePacket
extends Packet {
    public static final Pose[] poses = new Pose[]{Pose.SITTING, Pose.SWIMMING, Pose.STANDING};
    private final int crawling;

    public PosePacket(int crawling) {
        this.crawling = crawling;
    }

    public PosePacket(FriendlyByteBuf byteBuf) {
        this.crawling = byteBuf.readInt();
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.crawling);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                int crawling = this.crawling % poses.length;
                context.getSender().m_8127_();
                if (crawling == 0) {
                    ArmorStand stand;
                    PlayerData.get((Player)context.getSender()).ridingArmorStand = stand = new ArmorStand(context.getSender().m_9236_(), context.getSender().m_20185_(), context.getSender().m_20186_() - (double)1.55f, context.getSender().m_20189_());
                    stand.m_6842_(true);
                    stand.m_20331_(true);
                    stand.m_20242_(true);
                    stand.f_19794_ = true;
                    context.getSender().m_9236_().m_7967_((Entity)stand);
                    context.getSender().m_20329_((Entity)stand);
                }
                context.getSender().setForcedPose(null);
                if (crawling < 2) {
                    context.getSender().setForcedPose(poses[crawling]);
                }
                context.getSender().m_20124_(poses[crawling]);
            }
        });
        context.setPacketHandled(true);
    }
}

