/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking.C2S;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.zeus.sp.data.PlayerData;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import net.zeus.sp.level.item.SPItems;
import net.zeus.sp.level.item.items.Tablet;
import net.zeus.sp.networking.Packet;

public class SelectCameraPacket
extends Packet {
    private final int id;
    private final InteractionHand hand;

    public SelectCameraPacket(int id, InteractionHand hand) {
        this.id = id;
        this.hand = hand;
    }

    public SelectCameraPacket(FriendlyByteBuf byteBuf) {
        this.id = byteBuf.readInt();
        this.hand = (InteractionHand)byteBuf.m_130066_(InteractionHand.class);
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.id);
        byteBuf.m_130068_((Enum)this.hand);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = context.getSender();
            if (player == null || player.m_9236_().f_46443_) {
                return;
            }
            ItemStack itemStack = stack = !context.getSender().m_21120_(this.hand).m_150930_((Item)SPItems.TABLET.get()) ? PlayerData.get((Player)context.getSender()).tabletItem : context.getSender().m_21120_(this.hand);
            if (stack.m_41619_() || !stack.m_150930_((Item)SPItems.TABLET.get())) {
                return;
            }
            List<CameraBlockEntity> cameras = Tablet.getCameras(player.m_9236_(), stack);
            if (cameras.size() <= this.id) {
                return;
            }
            Tablet.getCurrentCamera((Player)player).ifPresent(camera -> camera.disconnect(player));
            cameras.get(this.id).accessCamera(player);
        });
        context.setPacketHandled(true);
    }
}

